;include pro chraneny rezim

;~~~~~~~~~~~~~ OFFSETY PRO SECONDARY PROCESOR ~~~~~~~~~~~~~~~

;0 = MONITOR                    

OFFS_SEC_MONIT		equ   0000000h     	;pro Monitor
  OFFS_SEC_PROC_CMONIT  equ   00F4000h    	;pocatecni adrsa codu pro monitor
  OFFS_SEC_PROC_SMONIT  equ   00002A7h    	;startovaci offset pro monitor
  OFFS_SEC_PROC_I1ENTRY equ   00008F8h    	;INT 1 entry point (ukazuje na SAVEX)
  OFFS_SEC_PROC_I3ENTRY equ   0000950h    	;INT 3 entry point (ukazuje na SAVEX)
  OFFS_SEC_PROC_DMONIT  equ   00F1000h    	;pocatecni adrsa dat pro monitor

OFFS_SEC_DRT		equ   0100000h     	;pro ladeni drahy DRT - 1Mb
OFFS_SEC_IDT         	equ   0200000h     	;pro IDT a interupt
OFFS_SEC_PROC_CONT   	equ   0210000h     	;pocatecni a startovaci adresa sec.
OFFS_SEC_PIS0        	equ   0220000h     	;pro PLC -stop 
OFFS_SEC_PLC_MAIN    	equ   0230000h     	;pro PLC - uzivatel PLC_MAIN 
OFFS_SEC_PLC_FAR0    	equ   0240000h     	;pro PLC - uzivatel PLC_FAR0 
OFFS_SEC_DATA        	equ   0250000h     	;pro datovy segment - inicializovany
OFFS_SEC_NKOR        	equ   0260000h     	;pro nelinearni korekce
OFFS_SEC_DUSR        	equ   0270000h     	;pro datovy segment inicial. pomoc.
OFFS_SEC_STACK       	equ   0280000h     	;pro STACK segment
OFFS_SEC_DATA1       	equ   0290000h     	;pro datovy segment - inicializovany
OFFS_SEC_DCOM        	equ   02A0000h     	;pro datovy segment - komunikacni cast
OFFS_DEBUGPLC_CODE   	equ   02B0000h     	;pro DEBUGPLC
OFFS_SEC_DPLC		equ   02C0000h		;pro lokalni data PLC
OFFS_SEC_INT_CODE	equ   02D0000h		;pro novy interpolaror
OFFS_SEC_CAN_CODE	equ   02E0000h		;pro CAN BUS
OFFS_SEC_CANU_CODE	equ   02F0000h		;pro CAN BUS (maxon)

OFFS_SEC_PROC_SU5    	equ   0300000h     	;pro SU05 a CDIST PCI
BEG_XLINX_SU5     	  equ  000000h	   
BEG_XLINX_CDIST     	  equ  008000h   

OFFS_SEC_PLC_E003    	equ   0310000h     	;pro PLC - uzivatel PLC_E003 
OFFS_SEC_PLC_E004    	equ   0320000h     	;pro PLC - uzivatel PLC_E004 
OFFS_SEC_PLC_E005    	equ   0330000h     	;pro PLC - uzivatel PLC_E005 
OFFS_SEC_PLC_E006    	equ   0340000h     	;pro PLC - uzivatel PLC_E006 
OFFS_SEC_PLC_E007    	equ   0350000h     	;pro PLC - uzivatel PLC_E007 
OFFS_SEC_PLC_E008    	equ   0360000h     	;pro PLC - uzivatel PLC_E008 
OFFS_SEC_PLC_E009    	equ   0370000h     	;pro PLC - uzivatel PLC_E009 

OFFS_SEC_PLC_E010    	equ   0380000h     	;pro PLC - uzivatel PLC_E010 
OFFS_SEC_PLC_E011    	equ   0390000h     	;pro PLC - uzivatel PLC_E011 
OFFS_SEC_PLC_E012    	equ   03A0000h     	;pro PLC - uzivatel PLC_E012 
OFFS_SEC_PLC_E013    	equ   03B0000h     	;pro PLC - uzivatel PLC_E013 
OFFS_SEC_PLC_E014    	equ   03C0000h     	;pro PLC - uzivatel PLC_E014 
OFFS_SEC_PLC_E015    	equ   03D0000h     	;pro PLC - uzivatel PLC_E015 
OFFS_SEC_PLC_E016    	equ   03E0000h     	;pro PLC - uzivatel PLC_E016 
OFFS_SEC_PLC_E017    	equ   03F0000h     	;pro PLC - uzivatel PLC_E017 

OFFS_SEC_3DKOR       	equ   0400000h     	;pro 3D nelin.korekce    - 1Mb
OFFS_SEC_DEADZONE       equ   04E0000h          ;pro DEADZONE

OFFS_SEC_EVENT		equ   0500000h		;pro udalosti

OFFS_SEC_CANT_CODE      equ   0600000h		;pro CAN BUS (TGA)	   
;..

OFFS_FLAT         	equ   0700000h     	;pro FLAT MODEL - 3Mb
 BEG_DATA_MTCP  	  equ  108000h   
 LEN_DATA_MTCP       	  equ  0F8000h
 BEG_DATA_LARGE      	  equ  100000h   
 BEG_STACK_FLAT      	  equ  200000h   
 TOP_STACK_FLAT      	  equ  280000h 


ADDR_SEC_DMA_H2      	equ   00h          ;*1000000H
ADDR_SEC_DMA_H       	equ   02Ch         ;*10000H
ADDR_SEC_DMA_L       	equ   0h           ;*1H
ADDR_SEC_DMA         	equ   02C0000h     ;pro datovy segment inicial. DMA


;~~~~~~~~~~~~~ Offsety pro verzi WIN ~~~~~~~~~~~~~

;Monitor
OFFS_WIN_PROC_DMONIT  	equ   0000000h    	;pocatecni adrsa dat pro monitor
  OFFS_WIN_PROC_SMONIT  equ   00002A7h    	;startovaci offset pro monitor
  OFFS_WIN_PROC_I1ENTRY equ   00008F8h    	;INT 1 entry point (ukazuje na SAVEX)
  OFFS_WIN_PROC_I3ENTRY equ   0000950h    	;INT 3 entry point (ukazuje na SAVEX)
  LEN_WIN_PROC_DMONIT   equ   0001000h		;velkost oblasti dat monitoru

OFFS_WIN_STACK       	equ   0010000h     	;pro STACK segment
OFFS_WIN_DATA1       	equ   0020000h     	;pro datovy segment - inicializovany
OFFS_WIN_DUSR        	equ   0030000h     	;pro datovy segment inicial. pomoc.
OFFS_WIN_NKOR        	equ   0040000h     	;pro nelinearni korekce
OFFS_WIN_PROC_SU5    	equ   0050000h     	;pro SU05 a CDIST PCI
OFFS_WIN_DEADZONE       equ   0060000h          ;pro DEADZONE
OFFS_WIN_DPLC		equ   0070000h		;pro lokalni data PLC

OFFS_WIN_PLC_MAIN    	equ   0080000h     	;pro PLC - uzivatel PLC_MAIN 
OFFS_WIN_PLC_FAR0    	equ   0090000h     	;pro PLC - uzivatel PLC_FAR0 
OFFS_WIN_PLC_E003    	equ   00A0000h     	;pro PLC - uzivatel PLC_E003 
OFFS_WIN_PLC_E004    	equ   00B0000h     	;pro PLC - uzivatel PLC_E004 
OFFS_WIN_PLC_E005    	equ   00C0000h     	;pro PLC - uzivatel PLC_E005 
OFFS_WIN_PLC_E006    	equ   00D0000h     	;pro PLC - uzivatel PLC_E006 
OFFS_WIN_PLC_E007    	equ   00E0000h     	;pro PLC - uzivatel PLC_E007 
OFFS_WIN_PLC_E008    	equ   00F0000h     	;pro PLC - uzivatel PLC_E008 
OFFS_WIN_PLC_E009    	equ   0100000h     	;pro PLC - uzivatel PLC_E009 

OFFS_WIN_PLC_E010    	equ   0110000h     	;pro PLC - uzivatel PLC_E010 
OFFS_WIN_PLC_E011    	equ   0120000h     	;pro PLC - uzivatel PLC_E011 
OFFS_WIN_PLC_E012    	equ   0130000h     	;pro PLC - uzivatel PLC_E012 
OFFS_WIN_PLC_E013    	equ   0140000h     	;pro PLC - uzivatel PLC_E013 
OFFS_WIN_PLC_E014    	equ   0150000h     	;pro PLC - uzivatel PLC_E014 
OFFS_WIN_PLC_E015    	equ   0160000h     	;pro PLC - uzivatel PLC_E015 
OFFS_WIN_PLC_E016    	equ   0170000h     	;pro PLC - uzivatel PLC_E016 
OFFS_WIN_PLC_E017    	equ   0180000h     	;pro PLC - uzivatel PLC_E017 


OFFS_WIN_DRT		equ   0200000h     	;pro ladeni drahy DRT - 1MB
OFFS_WIN_3DKOR       	equ   0300000h     	;pro 3D nelin.korekce - 1MB
OFFS_WIN_EVENT		equ   0400000h		;pro udalosti - 1MB

OFFS_WIN_FLAT         	equ   0500000h     	;pro FLAT MODEL - 3Mb


;$PROT_BEGIN

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;definice chyb loaderu
err_monit       	equ     1       ;chyba loadovani monitoru
err_plc1        	equ     2       ;chyba vytvoreni PLC1 bin
err_ndplc1		equ     4       ;chyba otevreni PLC1 bin
err_su5         	equ     7       ;chyba loadovani tabulky SU5
err_su5v        	equ     8       ;chybna verze tabulky SU5
err_pci         	equ     9       ;chyba loadovani tabulky PCI
err_pciv        	equ     10      ;chybna verze tabulky PCI
err_diskmst     	equ     11      ;chyba konfigurace DISKMST
err_dusrplc     	equ     12      ;priles velky pis_far
err_cdist        	equ     13      ;chyba loadovani tabulky SU5
err_cdistv        	equ     14      ;chybna verze tabulky SU5

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;definice chyb RUN-TIME (HALT_I)
ERR_RXD_1       EQU     70      ;NEZNAMA HLAVICKA PRI PRIJMU
ERR_TXD_1       EQU     71      ;CHYBA DRIVER_TXD
ERR_TXD_2       EQU     72      ;NEPOVEDLO SE PRENEST BLOK
UNK_INT_ERR     EQU     30      ;NAZNAMY INTERRUPT
ERR_PROT        EQU     13      ;OBECNA CHYBA OCHRANY
ERR_DIV         EQU      2      ;ERROR DELENI NULOU
ERR_KOPR        EQU      3      ;ERROR KOPROCESORU
ERR_2VNOR       EQU     10      ;DVOJITE VNORENI RASTRU 2.8 ms
ERR_2RATSR      EQU      4      ;DVOJITE VNORENI VYPOCTOVEHO RASTRU
ERR_TIMOUT      EQU      1      ;CASOVE HLIDANI BSP PROCESORU
ERR_AWAK        EQU      5      ;ZAKAZANO PROBUZENI KAZETY PO USPANI
ERR_PLCHLT      EQU      6      ;VYZADAN MODUL PIS_HALT Z PLC
ERR_DRT		EQU	 7	;VELKA ZMENA DRT
ERR_INT_SU5	EQU	11	;NEOCEKAVANY INTERRUPT OD SU5
ERR_INT_COUNT	EQU	12	;NEOCEKAVANY INTERRUPT OD COUNT
ERR_NOSU5_INT	EQU	14	;CHYBY INT.SU5


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

point_d STRUC  ;pointer DWORD
offs_d  dw  0
seg_d   dw  0
point_d ENDS

point_f STRUC  ;pointer FWORD
offs_f  dd  0
seg_f   dw  0
point_f ENDS

desc    STRUC  ; Definice poloky tabulky popisova segment
Limit   dw  0  ; GDT,LDT: limit segmentu (15-0)     
Base_l  dw  0  ;          bze segmentu (15-0)      
Base_m  db  0  ;          bze segmentu (23-16)     
Access  db  0  ;          pstupov prva          
Gran    db  0  ;          G, s, 0, AVL, limit (19-16)
Base_h  db  0  ;          bze segmentu (31-24)      
desc    ENDS   ; Kad poloka tabulky popisova m velikost 8 slabik.

StrukZas        STRUC   ; OFFSET
StareIP dw      0       ;   0    EIP (sem ukazuje SS:ESP po peruen)
        dw      0
StareCS dw      0       ;   4    CS
        dw      0
StareEF dw      0       ;   8    EFLAGS
        dw      0
StareSP dw      0       ;  12    ESP
        dw      0
StareSS dw      0       ;  16    SS
        dw      0       
StareES dd      0       ;  20    ES
StareDS dd      0       ;  24    DS
StareFS dd      0       ;  28    FS
StareGS dd      0       ;  32    GS
StrukZas        ENDS

;.......

SetBase MACRO   segr,segm               
        mov     AX,segr                 ; AX := segmentov registr
        shr     AH,4                    ; Do horn sti bze pat bity
        mov     segm&.Base_m,AH         ; 23-16 kompletn 24bitov adresy.
        mov     AX,segr                 ; AX := segmentov registr
        shl     AX,4                    ; Do doln sti bze pat bity
        mov     segm&.Base_l,AX         ; 15-0 kompletn 24bitov adresy.
        ENDM                            ;   

;........

;Presmerovani vektoru v RDT IO_APIC
;       P_ID =  ID APIC
;       RT_L =  adr IO_APIC pro IRQ low
;       RT_H =  adr IO_APIC pro IRQ high
;       INTN =  vektor IRQ
;       DELIVERY = maska + delivery mode
RT_FIXED  EQU   0H
RT_EXTINT EQU   700H
RT_MASKED EQU   10000H


IO_APIC_RT     MACRO  P_ID,RT_L,RT_H,INTN,DELIVERY
        mov     esi,IO_APIC_BASE
        mov     eax,RT_H                ;(IRQ)
        mov     fs:[esi],eax

        mov     esi,IO_APIC_WIN
        mov     eax,P_ID
        mov     fs:[esi],eax            ;

        mov     esi,IO_APIC_BASE
        mov     eax,RT_L
        mov     fs:[esi],eax

        mov     esi,IO_APIC_WIN
        mov     eax,DELIVERY            ;700 
        mov     al,byte ptr INTN        ;vektor
        mov     fs:[esi],eax            ;
        ENDM        


IO_APIC_RTp    MACRO  P_ID,RT_L,RT_H,INTN,DELIVERY
        mov     esi,IO_APIC_BASE
        mov     eax,RT_H                ;(IRQ)
        mov     fs:[esi],eax

        mov     esi,IO_APIC_WIN
        mov     eax,P_ID
        mov     fs:[esi],eax            ;

        mov     esi,IO_APIC_BASE
        mov     eax,RT_L
        mov     fs:[esi],eax

        mov     esi,IO_APIC_WIN
        mov     eax,DELIVERY            ;00 

	or 	ax,0b000h		;level, pin polarity

        mov     al,byte ptr INTN        ;vektor
        mov     fs:[esi],eax            ;
        ENDM        




;........
;nastaveni masky interuptu.. kdyz HODN = 0FFh, tak je zamaskovan
;(master)                    kdyz HODN = 000h, tak je povolen   
SET_INT_MS      MACRO   IMASK,HODN
                LOCAL en_int,end_int
                mov ah, HODN    ;co nastavit
                and ah, IMASK   ;000x0000
                jz  en_int
                in al,021h       ; IMR register
                or al,ah         ; Disable interrupt
                out 021h,al      ; 
                jmp end_int  
                
en_int:         mov ah, IMASK
                not ah
                in al,21h       ; IMR register
                and al,ah       ; Enable interrupt
                out 21h,al      ; 
end_int:
                ENDM

;........
;nastaveni masky interuptu.. kdyz HODN = 0FFh, tak je zamaskovan
;(kaskada slave)             kdyz HODN = 000h, tak je povolen   
SET_INT_SL      MACRO   IMASK,HODN
                LOCAL en_int,end_int
                mov ah, HODN    ;co nastavit
                and ah, IMASK   ;000x0000
                jz  en_int
                in al,0A1h       ; IMR register
                or al,ah         ; Disable interrupt
                out 0A1h,al      ; 
                jmp end_int  
                
en_int:         mov ah, IMASK
                not ah
                in al,0A1h       ; IMR register
                and al,ah        ; Enable interrupt
                out 0A1h,al      ; 
end_int:
                ENDM


;........

offs_DATA_COM MACRO bun
        mov     ebx,OFFS_SEC_DCOM        
        add     ebx,_ADDR_SEC_BASE_KNF
        add     bx,offset DATA_COM:bun
        ENDM


offs_DATA_COMFS MACRO bun
        mov     ax,0
        mov     fs,ax
        mov     ebx,OFFS_SEC_DCOM        
        add     ebx,_ADDR_SEC_BASE_KNF
        add     bx,offset DATA_COM:bun
        ENDM

;........

CALLF   MACRO   OFFS,SEL
        DB      9AH
        DW      OFFSET OFFS
        DW      SEL
        ENDM 

;........

JMPF    MACRO   OFFS,SEL
        DB      0EAH
        DW      OFFSET OFFS
        DW      SEL
        ENDM 

;.......

CALL_FLAT MACRO NAZEV
	db	0eah
	dw	LOWWORD (offset _TEXT32:&NAZEV)
        dw	SelSupCode32_SH
Ret_&NAZEV:
ENDM

;........

CALL_BETW MACRO NAZEV, NAZEV_FLAT
extrn NAZEV_FLAT:near
NAZEV	proc far
	mov  ax, SelSupData32_SH
	mov  ds, ax
	mov  es, ax
	call NAZEV_FLAT
	mov cx, SelSupD1_SH
	mov ds, cx
	mov es, cx
	db  0eah
	dw  offset code1:Ret_&NAZEV
	dw  0	
	dw  SelSupC_SH
NAZEV	endp
ENDM
	