
;........
;Bazova adresa sec.procesoru
ADDR_SEC_BASE_def       EQU     3000000H

;........

;Nastaveni vektoru preruseni (jen default hodnoty)
INT_0           EQU       0        ;divide error
INT_1           EQU       1        ;trap for monitor secondary
INT_3           EQU       3        ;break-point monitor secondary
INT_13          EQU      13        ;obecna chyba ochrany
INT_16          EQU      16        ;chyba koprocesoru
VECTOR_SEC_def  EQU     0CCH       ;vektory preruseni od local APIC secondary
VECTOR_BSP_def  EQU     0CDH       ;vektory preruseni od local APIC primary  
INT_INTDEB_def  EQU     0CFH       ;ineterrupt pro ladeni PLC intdebugem

;........

;pro komunikaci com2 - BSP (jen default hodnoty)
ADDRPORT_BSP_def        EQU     2f8h    ; 2f8 Address of COM2 port
DIVISOR_BSP_def         EQU     01H     ; 01 Divisor 01H latch value for 115200 baud
IMASK_BSP_def           =       IMASK_IRQ3
INTNUM_BSP_def          =       INTNUM_IRQ3

;pro komunikaci com1 - SEC KAZETA (jen default hodnoty)
ADDRPORT_SEC_def        EQU     3f8h    ; 3f8h Address of COM1 port
DIVISOR_SEC_def         EQU     01H     ; Divisor 01H latch value for 115200 baud
IMASK_SEC_def           =       IMASK_IRQ4
INTNUM_SEC_def          EQU     0CEh    ;seriovy kanal pro secondary
IO_APIC_RTL_SEC_def     =       IO_APIC_RT4L
IO_APIC_RTH_SEC_def     =       IO_APIC_RT4H


;pro komunikaci com2 - SEC INTDEBUG (jen default hodnoty)
ADDRPORT_IDB_def        EQU     2f8h    ; 2f8h Address of COM2 port
DIVISOR_IDB_def         EQU     0CH     ; Divisor 01H latch value for 115200 baud
IMASK_IDB_def           =       IMASK_IRQ3
INTNUM_IDB_def          EQU     0D0h    ;seriovy kanal pro secondary
IO_APIC_RTL_IDB_def     =       IO_APIC_RT3L
IO_APIC_RTH_IDB_def     =       IO_APIC_RT3H


;pro jednotku SU05 s interruptem (jen default hodnoty)
IO_APIC_RTL_SU5_def     =       IO_APIC_RT21L
IO_APIC_RTH_SU5_def     =       IO_APIC_RT21H
INTNUM_AXIS_def         =       0D1h
CHECK_TIMEOUT           =       100000	;Kontrolni doba (byla 50000)

;typ klavesnice (jen default hodnota)
TYP_KLAV_def            EQU     'R'     ;knf06


LCR_COM_VAL             EQU     1FH     ; 8 bits, 2 stop bits, SUDA PARITA
LCR_COM_DEB             EQU     03H     ; 8 bits, 2 stop bits, BEZ PARITY
LCR_COM_UPS             EQU     03H     ; 8 bits, 1 stop bits, BEZ PARITY
LCR_COM_PLC             EQU     03H     ; 8 bits, 1 stop bits, BEZ PARITY

;pro program monitor secondary musi byt com2 !
ADDRPORT_SEC_MONIT      EQU     2f8h    ; Address of COM2 port
DIVISOR_SEC_MONIT       EQU     0CH     ; Divisor 0CH latch value for 9600 baud

;........

IMASK_IRQ0              EQU     01      ;CASOVAC 55ms
INTNUM_IRQ0             EQU     08h     ; Number of interrupt vector (int0)
IMASK_IRQ1              EQU     02      ;PRO KLAVESNICI
INTNUM_IRQ1             EQU     09h     ; Number of interrupt vector (int1)
IMASK_IRQ2              EQU     04      ;PRO KASKADU   
INTNUM_IRQ2             EQU     0Ah     ; Number of interrupt vector (int2)
IMASK_IRQ3              EQU     08      ;COM2
INTNUM_IRQ3             EQU     0Bh     ; Number of interrupt vector (int3)
IMASK_IRQ4              EQU     10H     ;COM1
INTNUM_IRQ4             EQU     0Ch     ; Number of interrupt vector (int4)
IMASK_IRQ5              EQU     20H     ;PRO IRQ5      
INTNUM_IRQ5             EQU     0Dh     ; Number of interrupt vector (int5)
IMASK_IRQ6              EQU     40H     ;PRO IRQ6 - DISKETY
INTNUM_IRQ6             EQU     0Eh     ; Number of interrupt vector (int6)
IMASK_IRQ7              EQU     80H     ;PRO IRQ7 - LPT1   
INTNUM_IRQ7             EQU     0Fh     ; Number of interrupt vector (int7)
IMASK_IRQ8              EQU     01H     ;PRO IRQ8 - HODINY   
INTNUM_IRQ8             EQU     70h     ; Number of interrupt vector (int70)
IMASK_IRQ9              EQU     02H     ;PRO IRQ9
INTNUM_IRQ9             EQU     71h     ; Number of interrupt vector (int71)
IMASK_IRQ10             EQU     04H     ;PRO IRQ10
INTNUM_IRQ10            EQU     72h     ; Number of interrupt vector (int72)
IMASK_IRQ11             EQU     08H     ;PRO IRQ11
INTNUM_IRQ11            EQU     73h     ; Number of interrupt vector (int73)
IMASK_IRQ12             EQU     10H     ;PRO IRQ12
INTNUM_IRQ12            EQU     74h     ; Number of interrupt vector (int74)
IMASK_IRQ13             EQU     20H     ;PRO IRQ13
INTNUM_IRQ13            EQU     75h     ; Number of interrupt vector (int75)
IMASK_IRQ14             EQU     40H     ;PRO IRQ14 - IDE
INTNUM_IRQ14            EQU     76h     ; Number of interrupt vector (int76)
IMASK_IRQ15             EQU     80H     ;PRO IRQ15
INTNUM_IRQ15            EQU     77h     ; Number of interrupt vector (int77)

APIC_ENABLED EQU 00000100H   ;maska bitu enabled v registru SVR

EOI	EQU	0FEE000B0H	;end of interrupt register
DESTR   EQU     0FEE000E0H      ;Dest.format reg.
SVR     EQU     0FEE000F0H
LDR     EQU     0FEE000D0H
ESR     EQU     0FEE00280H
TPR     EQU     0FEE00080H
LVTTIM  EQU     0FEE00320H	;LOCAL VECTOR TABLE - TIMER
ICOUNT	EQU	0FEE00380H	;TIMER - INITIAL COUNTER REGISTER
CCOUNT	EQU	0FEE00390H	;TIMER - CURRENT COUNTER REGISTER
DIVIDE	EQU	0FEE003E0H	;TIMER DIVIDE CONFIGURATION REGISTER
LVT1    EQU     0FEE00350H
LVT2    EQU     0FEE00360H
LVT3    EQU     0FEE00370H
APIC_ID EQU     0FEE00020H        ;adresa APIC ID registru, DI - bity 24 - 27
ICR_HI  EQU     0FEE00310H        ;adresa horn sti interrupt command registru
ICR_LO  EQU     0FEE00300H        ;adresa doln sti interrupt command registru

IO_APIC_BASE EQU     0FEC00000H         ;I/O APIC BASE (SELECT REGISTER)
IO_APIC_WIN  EQU     0FEC00010H         ;I/O APIC BASE (I/O WINDOW)
IO_APIC_EOIR EQU     0FEC00040H         ;EOI pro I/O APIC
IO_APIC_ID   EQU     0H                 ;I/O APIC ID
IO_APIC_VER  EQU     1H                 ;I/O APIC VERSION
IO_APIC_RT0L EQU    10H                 ;Redirection Table 0 L
IO_APIC_RT0H EQU    11H                 ;Redirection Table 0 H
IO_APIC_RT1L EQU    12H                 ;Redirection Table 1 L
IO_APIC_RT1H EQU    13H                 ;Redirection Table 1 H
IO_APIC_RT2L EQU    14H                 ;Redirection Table 2 L
IO_APIC_RT2H EQU    15H                 ;Redirection Table 2 H
IO_APIC_RT3L EQU    16H                 ;Redirection Table 3 L
IO_APIC_RT3H EQU    17H                 ;Redirection Table 3 H
IO_APIC_RT4L EQU    18H                 ;Redirection Table 4 L
IO_APIC_RT4H EQU    19H                 ;Redirection Table 4 H
IO_APIC_RT5L EQU    1AH                 ;Redirection Table 5 L
IO_APIC_RT5H EQU    1BH                 ;Redirection Table 5 H
IO_APIC_RT6L EQU    1CH                 ;Redirection Table 6 L
IO_APIC_RT6H EQU    1DH                 ;Redirection Table 6 H
IO_APIC_RT7L EQU    1EH                 ;Redirection Table 7 L
IO_APIC_RT7H EQU    1FH                 ;Redirection Table 7 H
IO_APIC_RT8L EQU    20H                 ;Redirection Table 8 L
IO_APIC_RT8H EQU    21H                 ;Redirection Table 8 H
IO_APIC_RT9L EQU    22H                 ;Redirection Table 9 L
IO_APIC_RT9H EQU    23H                 ;Redirection Table 9 H
IO_APIC_RT10L EQU   24H                 ;Redirection Table 10 L
IO_APIC_RT10H EQU   25H                 ;Redirection Table 10 H
IO_APIC_RT11L EQU   26H                 ;Redirection Table 11 L
IO_APIC_RT11H EQU   27H                 ;Redirection Table 11 H
IO_APIC_RT12L EQU   28H                 ;Redirection Table 12 L
IO_APIC_RT12H EQU   29H                 ;Redirection Table 12 H
IO_APIC_RT13L EQU   2AH                 ;Redirection Table 13 L
IO_APIC_RT13H EQU   2BH                 ;Redirection Table 13 H
IO_APIC_RT14L EQU   2CH                 ;Redirection Table 14 L
IO_APIC_RT14H EQU   2DH                 ;Redirection Table 14 H
IO_APIC_RT15L EQU   2EH                 ;Redirection Table 15 L
IO_APIC_RT15H EQU   2FH                 ;Redirection Table 15 H

IO_APIC_RT16L EQU   30H                 ;Redirection Table 16 L
IO_APIC_RT16H EQU   31H                 ;Redirection Table 16 H
IO_APIC_RT17L EQU   32H                 ;Redirection Table 17 L
IO_APIC_RT17H EQU   33H                 ;Redirection Table 17 H
IO_APIC_RT18L EQU   34H                 ;Redirection Table 18 L
IO_APIC_RT18H EQU   35H                 ;Redirection Table 18 H
IO_APIC_RT19L EQU   36H                 ;Redirection Table 19 L
IO_APIC_RT19H EQU   37H                 ;Redirection Table 19 H
IO_APIC_RT20L EQU   38H                 ;Redirection Table 20 L
IO_APIC_RT20H EQU   39H                 ;Redirection Table 20 H
IO_APIC_RT21L EQU   3AH                 ;Redirection Table 21 L
IO_APIC_RT21H EQU   3BH                 ;Redirection Table 21 H
IO_APIC_RT22L EQU   3CH                 ;Redirection Table 22 L
IO_APIC_RT22H EQU   3DH                 ;Redirection Table 22 H
IO_APIC_RT23L EQU   3EH                 ;Redirection Table 23 L
IO_APIC_RT23H EQU   3FH                 ;Redirection Table 23 H


;*** Pro CAN-BUS ***

;Baudrate codes = Registervalues BTR0/BTR1
CAN_BAUD_1M     equ 0014h  ;   1 MBit / s
CAN_BAUD_500K   equ 001Ch  ; 500 kBit / s
CAN_BAUD_250K   equ 011Ch  ; 250 kBit / s
CAN_BAUD_125K   equ 031Ch  ; 125 kBit / s
CAN_BAUD_100K   equ 432Fh  ; 100 kBit / s
CAN_BAUD_50K    equ 472Fh  ;  50 kBit / s
CAN_BAUD_20K    equ 532Fh  ;  20 kBit / s
CAN_BAUD_10K    equ 672Fh  ;  10 kBit / s
CAN_BAUD_5K     equ 7F7Fh  ;   5 kBit / s


;Mask bits for Error conditions
CAN_ERR_OK        equ 00h
CAN_ERR_XMTFULL   equ 01h  ; Sendbuffer in Controller is full 
CAN_ERR_RCVEMPTY  equ 02h  ; no new Message received 
CAN_ERR_OVERRUN   equ 04h  ; CAN-Controller was read too late 
CAN_ERR_BUSERROR  equ 08h  ; BusError: an Errorcounter has reached Limit 
CAN_ERR_BUSOFF    equ 10h  ; BusError: CAN-Controller engaged 'Bus-Off' 
CAN_ERR_REGTEST   equ 20h  ; Error with Registertest of the CAN-Controllers 
CAN_ERR_RECVFULL  equ 100h ; Full buffer	


_?CAN_ERR_OK       = 0
_?CAN_ERR_XMTFULL  = 0
_?CAN_ERR_RCVEMPTY = 0
_?CAN_ERR_OVERRUN  = 0
_?CAN_ERR_BUSERROR = 0
_?CAN_ERR_BUSOFF   = 0
_?CAN_ERR_REGTEST  = 0

TCANRSR RECORD ?CAN_REGTEST:1,?CAN_BUSOFF:1,?CAN_BUSERROR:1,?CAN_OVERRUN:1,?CAN_RCVEMPTY:1,?CAN_XMTFULL:1 

;CAN-Message
TCANMSGS	STRUC
        CAN_ID 		DW 0		;11 Bit-ID                       
        CAN_RTR 	DB 0     	;true, if remote request         
        CAN_LEN 	DB 0     	;Number of valid Data bytes (0..8)
        CAN_DATA	DB 0 		;Databytes 0..7                   
        CAN_DATA_1	DB 0 		;Data 1                   
        CAN_DATA_2	DB 0 		;Data 2                   
        CAN_DATA_3	DB 0 		;Data 3                   
        CAN_DATA_4	DB 0 		;Data 4                   
        CAN_DATA_5	DB 0 		;Data 5                   
        CAN_DATA_6	DB 0 		;Data 6                   
        CAN_DATA_7	DB 0 		;Data 7                   
TCANMSGS	ENDS

