;URCENO PRO PLC

;:::::::::::: STRUCTURE :::::::::::::::::
__TEXBUSY	EQU 01		;Rozpracovannost instrukci TEX

BIT	RECORD	BIT15:1,BIT14:1,BIT13:1,BIT12:1,BIT11:1,BIT10:1,BIT9:1,BIT8:1,BIT7:1,BIT6:1,BIT5:1,BIT4:1,BIT3:1,BIT2:1,BIT1:1,BIT0:1
OSAR     RECORD OSA8:1,OSA7:1,OSA6:1,OSA5:1,OSA4:1,OSAZ:1,OSAY:1,OSAX:1 
OSAREX   RECORD OSA16:1,OSA15:1,OSA14:1,OSA13:1,OSA12:1,OSA11:1,OSA10:1,OSA9:1,OSA8_X:8 


;SADA PARAMETRU REGULATORU
REGULATORS STRUC
        REGULATOR_VERZE DW   ?          ;VERZE  
        KON_PS          DB 6 DUP (?)    ;PREPINACE X

        KON_X_KS        DB 6 DUP (?) 	;RYCHLOSTNI VAZBA "X" K2,K3,K4,K5,K7
        KON_Y_KS        DB 6 DUP (?) 	;RYCHLOSTNI VAZBA "Y" K2,K3,K4,K5,K7
        KON_Z_KS        DB 6 DUP (?) 	;RYCHLOSTNI VAZBA "Z" K2,K3,K4,K5,K7
        KON_4_KS        DB 6 DUP (?) 	;RYCHLOSTNI VAZBA "4" K2,K3,K4,K5,K7
        KON_5_KS        DB 6 DUP (?) 	;RYCHLOSTNI VAZBA "5" K2,K3,K4,K5,K7
        KON_6_KS        DB 6 DUP (?) 	;RYCHLOSTNI VAZBA "6" K2,K3,K4,K5,K7

        B_LIMIT_XS      DW   ?	  ;LIMIT PRO SKLUZ
        B_LIMIT_YS      DW   ?	  ;LIMIT PRO SKLUZ
        B_LIMIT_ZS      DW   ?	  ;
        B_LIMIT_4S      DW   ?	  ;
        B_LIMIT_5S      DW   ?	  ;
        B_LIMIT_6S      DW   ?	  ;

        B_IRCKON2_VRS   DW      ?   ;TANGENS      ;**
        B_IRCKON2_XS    DW 	?   ;TANGENS      ;**
        B_IRCKON2_YS    DW 	?   ;TANGENS      ;**
        B_IRCKON2_ZS    DW 	?   ;TANGENS      ;**
        B_IRCKON2_4S    DW 	?   ;TANGENS      ;**
        B_IRCKON2_5S    DW 	?   ;TANGENS      ;**
        B_IRCKON2_6S    DW 	?   ;TANGENS      ;**

        B_ROTACI2_VRS   DW	?   ;ROTACE       ;**
        B_ROTACI2_XS    DW	?   ;ROTACE       ;**
        B_ROTACI2_YS    DW	?   ;ROTACE       ;**
        B_ROTACI2_ZS    DW	?   ;ROTACE       ;**
        B_ROTACI2_4S    DW	?   ;ROTACE       ;**
        B_ROTACI2_5S    DW	?   ;ROTACE       ;**
        B_ROTACI2_6S    DW	?   ;ROTACE       ;**

        PROPORCIONAL_XS DW	?   ;ZESILENI     ;**
        PROPORCIONAL_YS DW	?   ;             ;**
        PROPORCIONAL_ZS DW	?   ;             ;**
        PROPORCIONAL_4S DW	?   ;             ;**
        PROPORCIONAL_5S DW	?   ;             ;**
        PROPORCIONAL_6S DW	?   ;             ;**

        LIMIT_DIFCIT_XS DD      ?   ;HLIDANI DIF.CITACE    
        LIMIT_DIFCIT_YS DD      ?   ;
        LIMIT_DIFCIT_ZS DD      ?   ;
        LIMIT_DIFCIT_4S DD      ?   ;
        LIMIT_DIFCIT_5S DD      ?   ;
        LIMIT_DIFCIT_6S DD      ?   ;

        FILTR_F1_XS     DD      ?   ;PROPORCIONAL. KONSTANTA FILTRU
        FILTR_F1_YS     DD      ?
        FILTR_F1_ZS     DD      ?
        FILTR_F1_4S     DD      ?
        FILTR_F1_5S     DD      ?
        FILTR_F1_6S     DD      ?

        FILTR_F2_XS     DD      ?   ;INTEGRACNI KONSTANTA FILTRU
        FILTR_F2_YS     DD      ?
        FILTR_F2_ZS     DD      ?
        FILTR_F2_4S     DD      ?
        FILTR_F2_5S     DD      ?
        FILTR_F2_6S     DD      ?

        FILTR_F3_XS     DD      ?   ;DERIVACNI KONSTANTA FILTRU
        FILTR_F3_YS     DD      ?
        FILTR_F3_ZS     DD      ?
        FILTR_F3_4S     DD      ?
        FILTR_F3_5S     DD      ?
        FILTR_F3_6S     DD      ?

        PREP_X_KS	DB 4 DUP (?)	;PREPINACE DLE REG_KONST3    FEEDFORW_EN, volno, volno, volno
        PREP_Y_KS	DB 4 DUP (?)
        PREP_Z_KS	DB 4 DUP (?)
        PREP_4_KS	DB 4 DUP (?)
        PREP_5_KS	DB 4 DUP (?)
        PREP_6_KS	DB 4 DUP (?)

        FEEDFORW_TS_XS  DD      ?   ;PARAMETR 1/Kv = Ts v tisicinach (pro FEEDFORWARD )
        FEEDFORW_TS_YS  DD      ?
        FEEDFORW_TS_ZS  DD      ?
        FEEDFORW_TS_4S  DD      ?
        FEEDFORW_TS_5S  DD      ?
        FEEDFORW_TS_6S  DD      ?

        FEEDFORW_TD_XS  DD      ?   ;PARAMETR Td = Tv*Ts v tisicinach (pro FEEDFORWARD )
        FEEDFORW_TD_YS  DD      ?
        FEEDFORW_TD_ZS  DD      ?
        FEEDFORW_TD_4S  DD      ?
        FEEDFORW_TD_5S  DD      ?
        FEEDFORW_TD_6S  DD      ?

REGULATORS ENDS

REG_KONST STRUC
        ??K2S             DB      ?
        ??K3S             DB      ?
        ??K4S             DB      ?
        ??K5S             DB      ?
        ??K6S             DB      ?
        ??K7S             DB      ?
REG_KONST ENDS

REG_KONST2 STRUC
        ??OXS             DB      ?
        ??OYS             DB      ?
        ??OZS             DB      ?
        ??O4S             DB      ?
        ??O5S             DB      ?
        ??O6S             DB      ?
REG_KONST2 ENDS

REG_KONST3  STRUC
	??FEEDFORW_EN	DB	?
			DB	?
			DB	?
			DB	?
REG_KONST3  ENDS


;Pro nastaveni dat v tabulce (POS,KOR,PAR) systemu
SET_NCTABS      STRUC                   ;
        NCTAB_VERZE     DB      ?       ;verze (1)
        NCTAB_MOD       DB      ?       ;mod prenosu (0=asynchr. 1=synchr.)
        NCTAB_TAB       DB      ?       ;kod tabulky (1=KOR, 2=POS, 6=PAR)
        NCTAB_SLOUPEC   DB      ?       ;sloupec v tabulce (1,2,..)
        NCTAB_RADEK     DB      ?       ;radek (KOR:1-99, POS:53-59, PAR0-95)
        NCTAB_DATA      DD      ?       ;BCD hodnota
        NCTAB_REZ       DB      ?
SET_NCTABS      ENDS

SW_VERZS        STRUC                   ;stejna je definovana v EXT_05.ASH
        SW_SYNCH        DB 8 DUP (0)    ;Synchronizace FF,F9,00,A5,6,NOT(6)
        SW_MODUL        DB 3 DUP (0)    ;Kod modulu (P01, P02)
        SW_REZ0         DB 0
        SW_LENGTH       DW 0            ;celkova delka
        SW_SUM_HEAD     DW 0            ;suma hlavicky
        SW_VERZE        DB 5 DUP (0)    ;6.001
        SW_REZ1         DB 3 DUP (0)
        SW_SUM_LEN      DW 0            ;delka pro sumaci
        SW_SUM          DW 0            ;suma
        SW_SUM_BEGIN    DW 0            ;20
        SW_REZ2         DW 0            ;
SW_VERZS        ENDS
;.....................




;:::::::::::: RECORD :::::::::::::::::

POS_STATUS1 RECORD POS_STV_POL:1,POS_STV_REF:1,POS_STV_SMER:1,POS_STV_JEDE:1
POS_STATUS2 RECORD POS_STV_ERR:1,POS_STV_PROG:1,POS_STV_DISP:1

POS_CONTROL1 RECORD POS_CNT_ADD:1,POS_CNT_NULRF:1,POS_CNT_PSEU:1,POS_CNT_REF:1,POS_CNT_G90:1
POS_CONTROL2 RECORD POS_CNT_CONT:1,POS_CNT_INIC:1,POS_CNT_RESET:1,POS_CNT_MP:1



;:::::::::::: MACRO :::::::::::::::::


;logicky posun CX,AX doleva
LSLL    MACRO
	SAL	AX,1
	RCL	CX,1
ENDM
	
;logicky posun CX,AX doprava
LSR     MACRO
	SHR	CX,1
	RCR	AX,1
ENDM

;aritmeticky posun CX,AX doleva se zachovanim znamenka
ASL     MACRO
	SAL	AX,1
	RCL	CX,1
	RCL	CX,1
	ROR	CX,1
ENDM
	
;aritmeticky posun CX,AX doprava se zachovanim znamenka
ASR     MACRO
	SAR	CX,1
	RCR	AX,1
ENDM	

;aritmeticky posun CX,AX doleva se zachovanim znamenka
;pocet v DL
ASLN    MACRO   NNN
        LOCAL ASLN0000
	MOV	DL,NNN
ASLN0000:
	SAL	AX,1
	RCL	CX,1
	RCL	CX,1
	ROR	CX,1
	DEC	DL
	JNZ	ASLN0000
ENDM
	
;aritmeticky posun CX,AX doprava se zachovanim znamenka
;pocet v DL
ASRN    MACRO   NNN
        LOCAL ASRN0000
	MOV	DL,NNN
ASRN0000:
	SAR	CX,1
	RCR	AX,1
	DEC	DL
	JNZ	ASRN0000
ENDM

;logicky posun CX,AX doleva - pocet v DL
LSLN    MACRO   NNN
        LOCAL   LSLN0000
	MOV	DL,NNN
LSLN0000:
	SAL	AX,1
	RCL	CX,1
	DEC	DL
	JNZ	LSLN0000
ENDM
	
;logicky posun CX,AX doprava - pocet v DL
LSRN    MACRO   NNN
        LOCAL LSRN0000
	MOV	DL,NNN
LSRN0000:
	SHR	CX,1
	RCR	AX,1
	DEC	DL
	JNZ	LSRN0000
ENDM	

;rotace spojenych registru CX,AX doprava
RRR     MACRO  
        LOCAL   RRR0000
	TEST	AL,MASK BIT0
	JZ	RRR0000
	STC
RRR0000: RCR	CX,1
	RCR	AX,1
ENDM

;rotace spojenych registru CX,AX doleva
RRL     MACRO   
        LOCAL RRL0000
	TEST	CH,MASK BIT7
	JZ	RRL0000
	STC
RRL0000: RCL	AX,1
	RCL	CX,1
ENDM

;2' DOPLNEK DWORD   VSTUP I VYSTUP AX,CX
DCM     MACRO
        LOCAL S?DCMA
	NOT	CX
	NEG	AX
	JNZ	S?DCMA
	INC	CX
S?DCMA:
ENDM

;ABSOLUTNI HODNOTA DWORD   VSTUP I VYSTUP AX,CX
DAB     MACRO   
        LOCAL S?DABA
	TEST	CH,80H
	JZ	S?DABA
	NOT	CX
	NEG	AX
	JNZ	S?DABA
	INC	CX
S?DABA:
ENDM

;VYSTUP NA PERIFERIE - PRIMO
OUTM    MACRO   PORT
        MOV     DX,PORT
        OUT     DX,AL
ENDM        

;VSTUP Z PERIFERIE - PRIMO
INM     MACRO   PORT
        MOV     DX,PORT
        IN      AL,DX
ENDM        

;VYSTUP NA PERIFERIE - NEPRIMO
OUTMB   MACRO   BAZE,OFFS
        MOV     DX,BAZE
        ADD     DX,OFFS
        OUT     DX,AL
ENDM        

;VSTUP Z PERIFERIE - NEPRIMO
INMB    MACRO   BAZE,OFFS
        MOV     DX,BAZE
        ADD     DX,OFFS
        IN      AL,DX
ENDM        

	
;PREVOD NA ANALOGOVE NAPETI PRO SU02
ANAL    MACRO
        LOCAL S?ANAL
	OR	AX,AX
	JNS	S?ANAL
	NEG	AX
	OR	AH,MASK BIT7
S?ANAL:
ENDM

;UZIVATELSKA MAKRA
CMPCX   MACRO
        CMP CX,CS:[BX]
ENDM        

CMPCX4  MACRO
        CMP CX,CS:[BX]+4
ENDM        

MOVCX   MACRO
        MOV CX,CS:[BX]
ENDM        

MOVCLX  MACRO
        MOV CL,CS:[BX]
ENDM        

MOVDICX MACRO
        MOV DS:[DI],CX
ENDM        

;:::::::::::: EXTERNAL :::::::::::::::::

;INCLUDE PRO EXTERNAL SYMBOLY V JAZYCE TECHNOL
;PRO TVORBU PROGRAMOVATELNEHO INTERFEJSU STROJE


EXTRN BUKON90:WORD,BUKON91:WORD,BUKON92:WORD,BUKON93:WORD,BUKON94:WORD
EXTRN BUKON65:WORD,BUKON68:WORD
_?BUKON90 = 2
_?BUKON91 = 2
_?BUKON92 = 2
_?BUKON93 = 2
_?BUKON94 = 2
_?BUKON65 = 2
_?BUKON68 = 2
EXTRN  BUKON170:WORD,BUKON200:WORD

EXTRN VRETENO_X:BYTE,VRETENO_Y:BYTE,VRETENO_Z:BYTE
EXTRN VRETENO_4:BYTE,VRETENO_5:BYTE,VRETENO_6:BYTE
_?VRETENO_X = 1
_?VRETENO_Y = 1
_?VRETENO_Z = 1
_?VRETENO_4 = 1
_?VRETENO_5 = 1
_?VRETENO_6 = 1

EXTRN VRETENO2_X:BYTE,VRETENO2_Y:BYTE,VRETENO2_Z:BYTE
EXTRN VRETENO2_4:BYTE,VRETENO2_5:BYTE,VRETENO2_6:BYTE
_?VRETENO2_X = 1
_?VRETENO2_Y = 1
_?VRETENO2_Z = 1
_?VRETENO2_4 = 1
_?VRETENO2_5 = 1
_?VRETENO2_6 = 1


EXTRN DOJIZ_POLOH_EX:WORD,V?MIN:WORD,DOJIZ2_POLOH_EX:WORD
EXTRN ALFA_POLOH_BIN_EX:DWORD,SPIAX_RAMP_EX:WORD
_?DOJIZ2_POLOH_EX = 2
_?DOJIZ_POLOH_EX = 2
_?V?MIN = 2

EXTRN ZMENA_SCPI:BYTE

EXTRN B_POL:DWORD,B_INK:DWORD,DIFCIT_X:DWORD,KI_PI:WORD

EXTRN B_IRCKON_X:DWORD,B_ZBYIRC_X:DWORD
EXTRN B_IRCVRE_X:DWORD
EXTRN B_IRCKON_UX:DWORD
EXTRN BUKON60_R:BYTE,BUKON60:DWORD,BUKON60_R2:BYTE

EXTRN AKTUAL_PORT_VR:DWORD
EXTRN AKTUAL_SU4VR_IRC:WORD,AKTUAL_SU4VRAX_IRC:WORD
EXTRN AKTUAL_SU4VR_ANL:WORD,AKTUAL_SU4VRAX_ANL:WORD
EXTRN SU4_OUT_PLC:WORD,AKTUAL_SU4VRAX2_IRC:WORD,AKTUAL_SU4VRAX2_ANL:WORD
EXTRN SU4_OFFS_ANL:WORD

EXTRN ?PAMCD:BYTE,?PAMCD_SI:WORD
EXTRN PLC_STACK:WORD,PLC_STACK_END:WORD,POINT_STACK:WORD,COUNT_STACK:BYTE

EXTRN VYSOVERS:WORD
_?VYSOVERS = 2

EXTRN BUN_JOGMIK:BYTE
_?BUN_JOGMIK = 1

EXTRN   B_ZBYIRC2_X:WORD,B_ZBYIRC2_Y:WORD,B_ZBYIRC2_Z:WORD
EXTRN   B_ZBYIRC2_4:WORD,B_ZBYIRC2_5:WORD,B_ZBYIRC2_6:WORD
EXTRN   RTM_TEST:BYTE

;SADY PARAMETRU REGULATORU
EXTRN   REG_AKTUAL:REGULATORS
EXTRN   REGULATOR_SADA1:REGULATORS
EXTRN   REGULATOR_SADA2:REGULATORS
EXTRN   REGULATOR_SADA3:REGULATORS
EXTRN   REGULATOR_SADA4:REGULATORS

EXTRN   TAB_BREAK:BYTE
EXTRN   POCET_BREAK:BYTE
EXTRN   FL_50PROC_PLC:BYTE
EXTRN   FL_ANALOG_G96:BYTE
_?FL_50PROC_PLC = 1

;MULTIPLEXOVANE VSTUPY
EXTRN   TAB_MUX_PORT_1:BYTE,TAB_MUX_PORT_2:BYTE
EXTRN   TAB_MUX_1:BYTE,TAB_MUX_2:BYTE
EXTRN   TAB_MUX_PORT_FAST:BYTE
EXTRN   TAB_MUX_PORT_4:BYTE,TAB_MUX_PORT_5:BYTE
EXTRN   TAB_MUX_4:BYTE,TAB_MUX_5:BYTE


;PORTY Z PANELU SYSTEMU
EXTRN PTLTOC:BYTE
EXTRN PTL1IN:BYTE,PTL2IN:BYTE,PTL3IN:BYTE
_?PTL1IN = 1
_?PTL2IN = 1
_?PTL3IN = 1
_?PTLTOC = 1

EXTRN   REZIMPI:BYTE
_?REZIMPI = 1

EXTRN   BUF_POTENC:DWORD,KROK_TOC_EXT:WORD
_?KROK_TOC_EXT = 2

EXTRN   BZH08RTM:BYTE,SET_NCTAB:BYTE
EXTRN   RUN_PROVOZ:BYTE
_?BZH08RTM = 1
_?SET_NCTAB = 1

;NEPRIMA ADRESACE PORTU PRO SNIMANI IRC A ANALOGOVE VYSTUPY
EXTRN   BAZE_IRC_X:WORD,BAZE_IRC_Y:WORD,BAZE_IRC_Z:WORD,BAZE_IRC_KOP:WORD
EXTRN   BAZE_IRC_4:WORD,BAZE_IRC_5:WORD,BAZE_IRC_6:WORD,BAZE_IRC_TOC:WORD
EXTRN   BAZE_ANL_X:WORD,BAZE_ANL_Y:WORD,BAZE_ANL_Z:WORD,BAZE_ANL_KOP:WORD
EXTRN   BAZE_ANL_4:WORD,BAZE_ANL_5:WORD,BAZE_ANL_6:WORD,BAZE_ANL_TOC:WORD

;POLOHOVACI JEDNOTKY
EXTRN   POS_FEED_ACT_X:DWORD
EXTRN   POS_STATUS1_X:BYTE,POS_STATUS2_X:BYTE
EXTRN   POS_CONTROL1_X:BYTE,POS_CONTROL2_X:BYTE

;ZOBRAZENI VSTUPU A VYSTUPU
EXTRN   VI_INPUT:BYTE,VI_OUTPUT:BYTE,DYN_STATUS_OUT:BYTE

;ADAPTABILNI FILTR VRETENE
EXTRN   ADP_PRUMER:WORD,ADP_VZOREK:WORD,ADP_FILTR_BUSY:BYTE
EXTRN   ADP_FILTR_ENABLE:BYTE


EXTRN	PRENOS1:BYTE,PRENOS2:BYTE,PRENOS3:BYTE,PRENOS4:BYTE
SAVE_PLCMAN EQU PRENOS1
POSUN_AUTMAN EQU PRENOS1
FL_VOLBA EQU PRENOS1
FL_VOLBA_BLOK EQU PRENOS1
BACK_AUTMAN EQU PRENOS1
BACK_AUTMAN_ALL EQU PRENOS1
TL_STOP EQU PRENOS1
REQ_AUTMAN EQU PRENOS1
PRE1R RECORD ?SAVE_PLCMAN:1,?POSUN_AUTMAN:1,?TL_STOP:1,?BACK_AUTMAN_ALL:1,?BACK_AUTMAN:1,?REQ_AUTMAN:1,?FL_VOLBA_BLOK:1,?FL_VOLBA:1

VR_AUT EQU PRENOS2
VR_BB  EQU PRENOS2
VR_M01 EQU PRENOS2
VR_AVP EQU PRENOS2
VR_LOM EQU PRENOS2
VR_ND  EQU PRENOS2
REQ_SHIFT EQU PRENOS2
ACT_SHIFT EQU PRENOS2
PRE2R RECORD ?ACT_SHIFT:1,?REQ_SHIFT:1,?VR_ND:1,?VR_LOM:1,?VR_AVP:1,?VR_M01:1,?VR_BB:1,?VR_AUT:1

EXTRN  AX_SWITCH:BYTE, AX_COPY:BYTE, AX_DISABLE:BYTE, AX_DISABLE2:BYTE
_?AX_SWITCH   = 1
_?AX_COPY     = 1
_?AX_DISABLE  = 1
_?AX_DISABLE2 = 1
AX_SWITCH_X EQU AX_SWITCH
AX_SWITCH_Y EQU AX_SWITCH
AX_SWITCH_Z EQU AX_SWITCH
AX_SWITCH_4 EQU AX_SWITCH
AX_SWITCH_5 EQU AX_SWITCH
AXSW6       EQU AX_SWITCH
AXSW7       EQU AX_SWITCH
AXSW8       EQU AX_SWITCH
AXSWR RECORD ?AXSW8:1,?AXSW7:1,?AXSW6:1,?AX_SWITCH_5:1,?AX_SWITCH_4:1,?AX_SWITCH_Z:1,?AX_SWITCH_Y:1,?AX_SWITCH_X:1

EXTRN REQ_EXT_DRT:BYTE,REQ_EXT_DRT2:BYTE
_?REQ_EXT_DRT = 1
_?REQ_EXT_DRT2 = 1
REQ_EXT_DRT_X  EQU REQ_EXT_DRT
REQ_EXT_DRT_Y  EQU REQ_EXT_DRT
REQ_EXT_DRT_Z  EQU REQ_EXT_DRT
REQ_EXT_DRT_4  EQU REQ_EXT_DRT
REQ_EXT_DRT_5  EQU REQ_EXT_DRT
REQ_EXT_DRT_6  EQU REQ_EXT_DRT
REQ_EXT_DRT_7  EQU REQ_EXT_DRT
REQ_EXT_DRT_8  EQU REQ_EXT_DRT
REQ_EXT_DRT_9  EQU REQ_EXT_DRT2
REQ_EXT_DRT_10 EQU REQ_EXT_DRT2
REQ_EXT_DRT_11 EQU REQ_EXT_DRT2
REQ_EXT_DRT_12 EQU REQ_EXT_DRT2
REQ_EXT_DRT_13 EQU REQ_EXT_DRT2
REQ_EXT_DRT_14 EQU REQ_EXT_DRT2
REQ_EXT_DRT_15 EQU REQ_EXT_DRT2
REQ_EXT_DRT_16 EQU REQ_EXT_DRT2

EXDRTR RECORD ?REQ_EXT_DRT_8:1,?REQ_EXT_DRT_7:1,?REQ_EXT_DRT_6:1,?REQ_EXT_DRT_5:1,?REQ_EXT_DRT_4:1,?REQ_EXT_DRT_Z:1,?REQ_EXT_DRT_Y:1,?REQ_EXT_DRT_X:1
EXDRT2R RECORD ?REQ_EXT_DRT_16:1,?REQ_EXT_DRT_15:1,?REQ_EXT_DRT_14:1,?REQ_EXT_DRT_13:1,?REQ_EXT_DRT_12:1,?REQ_EXT_DRT_11:1,?REQ_EXT_DRT_10:1,?REQ_EXT_DRT_9:1

EXTRN AX_EXT_DRT:DWORD

EXTRN SET_SLS:BYTE,ACT_ADTL:BYTE,__FL_ON_REK:BYTE,SIM_SPEED_PT:DWORD
_?SET_SLS = 1
_?ACT_ADTL = 1

EXTRN REQ_SEND:BYTE
_?REQ_SEND = 1
REQ_SEND_TABTECH EQU REQ_SEND
REQ_SEND_PLCMEM  EQU REQ_SEND
REQ_SEND_NCTAB   EQU REQ_SEND
RQS4             EQU REQ_SEND
RQS5             EQU REQ_SEND
RQS6             EQU REQ_SEND
RQS7             EQU REQ_SEND
RQS8             EQU REQ_SEND
REQ_SNDR RECORD ?RQS8:1,?RQS7:1,?RQS6:1,?RQS5:1,?RQS4:1,?REQ_SEND_NCTAB:1,?REQ_SEND_PLCMEM:1,?REQ_SEND_TABTECH:1

EXTRN CONT_ANGLE:BYTE,LOCATE_ANGLE:DWORD,RAMP_ANGLE:WORD,AXIS_ANGLE:WORD,ACTUAL_ANGLE:DWORD
EXTRN AXIS_ANGLE2:WORD,INCLINE_ANGLE:DWORD
_?RAMP_ANGLE  = 2
_?AXIS_ANGLE  = 2
_?AXIS_ANGLE2 = 2
_?CONT_ANGLE  = 1
REQ_ANGLE_R 	EQU CONT_ANGLE 
REQ_ANGLE_L 	EQU CONT_ANGLE  
MAN_ANGLE   	EQU CONT_ANGLE  
WAIT_ANGLE  	EQU CONT_ANGLE  
WAIT_EQ_ANGLE   EQU CONT_ANGLE  
HOSE_ANGLE     	EQU CONT_ANGLE  
SPHERE_ANGLE   	EQU CONT_ANGLE  
EQ_ANGLE       	EQU CONT_ANGLE  
CONT_ANGLER RECORD ?EQ_ANGLE:1,?SPHERE_ANGLE:1,?HOSE_ANGLE:1,?WAIT_EQ_ANGLE:1,?WAIT_ANGLE:1,?MAN_ANGLE:1,?REQ_ANGLE_R:1,?REQ_ANGLE_L:1

KEY_MEM EQU BZH25
KEY_CNT EQU BZH25
KEY_?2  EQU BZH25
KEY_?3  EQU BZH25
KEY_?4  EQU BZH25
KEY_?5  EQU BZH25
KEY_?6  EQU BZH25
KEY_?7  EQU BZH25
KEY_PLCR RECORD ?KEY_?7:1,?KEY_?6:1,?KEY_?5:1,?KEY_?4:1,?KEY_?3:1,?KEY_?2:1,?KEY_CNT:1,?KEY_MEM:1

EXTRN	SHIFT_CONTROL:BYTE,SHIFT_ENABLE:BYTE,SHIFT_X:DWORD
_?SHIFT_CONTROL = 1
_?SHIFT_ENABLE  = 1

EXTRN   MODULE_BLOCK_INIT:BYTE,MODULE_BLOCK_DONE:BYTE,EXT_FEED_G00_AUTMAN:WORD,REFERENCE:BYTE
_?EXT_FEED_G00_AUTMAN = 2
_?REFERENCE = 1

EXTRN	EXT_FEED_AUTMAN_2:WORD,EXT_FEED_AUTMAN_3:WORD,EXT_FEED_AUTMAN_4:WORD
EXTRN	EXT_FEED_AUTMAN_5:WORD,EXT_FEED_AUTMAN_6:WORD
_?EXT_FEED_AUTMAN_2 = 2
_?EXT_FEED_AUTMAN_3 = 2
_?EXT_FEED_AUTMAN_4 = 2
_?EXT_FEED_AUTMAN_5 = 2
_?EXT_FEED_AUTMAN_6 = 2

EXTRN  PTLTOC_P1:BYTE,PTLTOC_P2:BYTE,KROK_TOC_EXT2:WORD
EXTRN  PTLTOC_P1_2:BYTE,PTLTOC_P2_2:BYTE 
_?PTLTOC_P1 = 1
_?PTLTOC_P2 = 1
_?PTLTOC_P1_2 = 1
_?PTLTOC_P2_2 = 1
_?KROK_TOC_EXT2 = 2

EXTRN  PB_AX_X:DWORD,PB_AX_Y:DWORD,PB_AX_Z:DWORD,PB_AX_4:DWORD
EXTRN  PB_AX_5:DWORD,PB_AX_6:DWORD,PB_AX_I:DWORD,PB_AX_J:DWORD
EXTRN  PB_AX_K:DWORD,PB_AX_E:DWORD
EXTRN  PB_AX_ZM1:BYTE,PB_AX_ZM2:BYTE	
EXTRN  __PLCINI_EVENT:BYTE,__AXSPI_EVENT:BYTE,__PLCCLR_EVENT:BYTE	
_?PB_AX_ZM1 = 1
_?PB_AX_ZM2 = 1
ZMSXPI	EQU PB_AX_ZM1
ZMSYPI	EQU PB_AX_ZM1
ZMSZPI	EQU PB_AX_ZM1
ZMS4PI	EQU PB_AX_ZM1
ZMS5PI	EQU PB_AX_ZM1
ZMS6PI	EQU PB_AX_ZM1
ZMSIPI  EQU PB_AX_ZM2
ZMSJPI  EQU PB_AX_ZM2
ZMSKPI  EQU PB_AX_ZM2
ZMSEPI  EQU PB_AX_ZM2
PB_AX_ZM1R RECORD ?ZMS6PI:1,?ZMS5PI:1,?ZMS4PI:1,?ZMSZPI:1,?ZMSYPI:1,?ZMSXPI:1
PB_AX_ZM2R RECORD ?ZMSEPI:1,?ZMSKPI:1,?ZMSJPI:1,?ZMSIPI:1

EXTRN REZERD2:BYTE
REZ_USRR RECORD ??R_USR7:1,??R_USR6:1,??R_USR5:1,??R_USR4:1,??R_USR3:1,??R_USR2:1,??R_USR1:1,?FIX_SHIFT1:1
FIX_SHIFT1 EQU REZERD2

EXTRN	TIME_DIST:DWORD,CIRC_DIST:DWORD

EXTRN	PB20PI2:BYTE
_?PB20PI2 = 1	
PB20RX	RECORD	?PO_OS8PI:1,?PO_OS7PI:1,???PO6:6
PB20R2	RECORD	?PO_OS16PI:1,?PO_OS15PI:1,?PO_OS14PI:1,?PO_OS13PI:1,?PO_OS12PI:1,?PO_OS11PI:1,?PO_OS10PI:1,?PO_OS9PI:1
PO_OS7PI  EQU PB20PI
PO_OS8PI  EQU PB20PI
PO_OS9PI  EQU PB20PI2
PO_OS10PI EQU PB20PI2
PO_OS11PI EQU PB20PI2
PO_OS12PI EQU PB20PI2
PO_OS13PI EQU PB20PI2
PO_OS14PI EQU PB20PI2
PO_OS15PI EQU PB20PI2
PO_OS16PI EQU PB20PI2


EXTRN	VAZBAPI2:BYTE
_?VAZBAPI2 = 1
VAZBAXR RECORD ?VAZBA_8:1,?VAZBA_7:1,???V06:6
VAZBA2R RECORD ?VAZBA_16:1,?VAZBA_15:1,?VAZBA_14:1,?VAZBA_13:1,?VAZBA_12:1,?VAZBA_11:1,?VAZBA_10:1,?VAZBA_9:1
VAZBA_7	  EQU	VAZBAPI
VAZBA_8	  EQU	VAZBAPI
VAZBA_9	  EQU	VAZBAPI2
VAZBA_10  EQU	VAZBAPI2
VAZBA_11  EQU	VAZBAPI2
VAZBA_12  EQU	VAZBAPI2
VAZBA_13  EQU	VAZBAPI2
VAZBA_14  EQU	VAZBAPI2
VAZBA_15  EQU	VAZBAPI2
VAZBA_16  EQU	VAZBAPI2

EXTRN	BZH08PI2:BYTE
_?BZH08PI2 = 1
BZH8PDR RECORD ?MP8PI:1,?MP7PI:1,???BZ806:6
BZH8P2R RECORD ?MP16PI:1,?MP15PI:1,?MP14PI:1,?MP13PI:1,?MP12PI:1,?MP11PI:1,?MP10PI:1,?MP9PI:1
MP7PI  EQU BZH08PI
MP8PI  EQU BZH08PI
MP9PI  EQU BZH08PI2
MP10PI EQU BZH08PI2
MP11PI EQU BZH08PI2
MP12PI EQU BZH08PI2
MP13PI EQU BZH08PI2
MP14PI EQU BZH08PI2
MP15PI EQU BZH08PI2
MP16PI EQU BZH08PI2
MP17PI EQU BZH08PI2

EXTRN  SERV_ACTIVE:WORD
EXTRN  SERV_LINK_XS:WORD
_?SERV_LINK_XS = 2

EXTRN _G_CAN_PORTBASE:WORD,_G_CAN_BAUD:WORD,_G_CAN_REGID:WORD
EXTRN _G_CAN_READMSG:DWORD,_G_CAN_WRITEMSG:DWORD,_POI_CAN_PLC_RECV:DWORD,_POI_CAN_SEND:DWORD


PB30R   RECORD  ?XCHG_INCR:1,?G23G00:1,?SELBPI:1,?ZBYTKY:1,?SMERMAN:1,?G23PI:1
G23PI	EQU	PB30
SMERMAN	EQU	PB30
ZBYTKY	EQU	PB30
SELBPI	EQU	PB30
G23G00	EQU	PB30
XCHG_INCR EQU   PB30

EXTRN	SPEED_REVERS:BYTE,SLM_POWER:BYTE,CROSS_SET:BYTE,B_SUM_CROSS:DWORD
EXTRN	LIMIT_FEED:DWORD,LIMIT_FEED_G00:DWORD
_?SPEED_REVERS = 1
_?SLM_POWER = 1
_?CROSS_SET = 1

EXTRN	B_CROSS_FILTER:BYTE
B_CROSS_FR RECORD ?B_CROSSREZ:7,?CROSS_FILTER:1
CROSS_FILTER EQU B_CROSS_FILTER

EXTRN	K1_ADDCROSS_S1:DWORD,K2_ADDCROSS_S1:DWORD
EXTRN	K1_ADDCROSS_S2:DWORD,K2_ADDCROSS_S2:DWORD
EXTRN	K1_ADDCROSS_S3:DWORD,K2_ADDCROSS_S3:DWORD
