;--------------------------------------------------
;Komunikacni oblast dat
;--------------------------------------------------

MAX_POC_OS_ODM	        	EQU 16

;Deklarace struktury pro konfiguraci systemu:
SEC_KNFS	STRUC

     ;APIC-ID
	BOOT_ID2		DD 0  	;pro	BSP
	SECOND_ID2	      	DD 0	;ID pro secondary

     ;konfigurace COM kanalu pro secondary - kazeta(SU04)
	ADDRPORT_SEC		DW  ADDRPORT_SEC_def	 ;3F8h of COM1
	DIVISOR_SEC		DB  DIVISOR_SEC_def	 ;1 for	115200
	IMASK_SEC		DB  IMASK_SEC_def	 ;IMASK_IRQ4
	IO_APIC_RTL_SEC		DD  IO_APIC_RTL_SEC_def	 ;redirection table low
	IO_APIC_RTH_SEC		DD  IO_APIC_RTH_SEC_def	 ;redirection table high

     ;konfigurace COM kanalu pro secondary - Intdebug
	ADDRPORT_IDB		DW  ADDRPORT_IDB_def	 ;2F8h of COM2
	DIVISOR_IDB		DB  DIVISOR_IDB_def	 ;1 for	115200
	IMASK_IDB		DB  IMASK_IDB_def	 ;IMASK_IRQ3
	IO_APIC_RTL_IDB		DD  IO_APIC_RTL_IDB_def	 ;redirection table low
	IO_APIC_RTH_IDB		DD  IO_APIC_RTH_IDB_def	 ;redirection table high

     ;nastaveni vektoru preruseni
	VECTOR_SEC		DW 0FFFFh	    ;0CCH  vektor od local APIC	secondary 
	INTNUM_SEC		DW 0FFFFh	    ;0CEh  seriovy kanal pro secondary (COM1)
	INT_INTDEB		DW 0FFFFh	    ;0CFh  ladeni PLC intdebugem (break PLC)
	INTNUM_IDB		DW 0FFFFh	    ;0D0H  seriovy kanal pro ladeni plc (COM2)

     ;nastaveni prodlevy pro testovani pozadavku na MONITOR
	TIM_MONITOR		DD 500000h	    ;prodleva pro nabehnuti systemu   

     ;nastaveni bazove adresy sec. procesoru
	ADDR_SEC_BASE		DD ADDR_SEC_BASE_def   

     ;nastaveni konfigurace pro MTCP
	MTCP			DB 32 dup (0)

SEC_KNFS	ENDS 

;.....................

;Deklarace struktuty pro komunikacni oblast
KTOS	STRUC
	TOS_BEGIN		DW 0
	TOS_END			DW 0
	TOS_ACTUAL		DW 0
	TOS_COUNT_BSP		DW 0
	TOS_COUNT_SEC		DW 0
KTOS	ENDS


;.....................

;Konfigurace pro PCI karty

BOARDS	STRUC
	PCI_KLIC		DB 	'$PCI '
	PCI_VERSE		DB	'01 '
	PCI_COUNT		DB	'00 ',0dh,0ah
BOARDS	ENDS

CONFS	STRUC
	PCI_TYP_CARD		DB 0	;typ desky (82h=SU05)
	PCI_STATUS		DB 0	;status (SU5 nepouziva, dava 00)
	PCI_POSITION		DB 0	;pozice,na ktere byla deska nalezena, cislo 0..32
	PCI_HIGH_ADDR		DB 0	;horni byte i/o adresy
	PCI_INTERRUPT		DB 0	;pouzity interrupt
	PCI_RESERVA1		DB 0	;reserva
CONFS	ENDS


BOARDS_NET  struc
            klic_net        db      '$xxx '		;'$NET '
            verse_net       db      '00 '         	;'01 '  
            count_net       db      '00 ',0dh,0ah   ;pocet sitovych desek
BOARDS_NET  ends

CONFS_NET   struc
            vendor_id       dw      0ffffh          ;manufacture of the device
                                                    ;FFFFh is invalid value
            device_id       dw      0               ;device from the maker
            io_add_net      dw      0               ;I/O address 
            mem_addl_net    dw      0               ;memory address low
            mem_addh_net    dw      0               ;memory address high
            reserva_net     dw      0               ;(used interupt line)
CONFS_NET   ends


;.....................

;Pro technologicke tabulky
TAB_TECHNOLS    STRUC
        TCH_VERZE       DW      ?       ;verze
        TCH_SLOUPCE     DW      ?       ;pocet sloupcu
        TCH_RADKY       DW      ?       ;pocet radku
        TCH_VOLBA       DW      ?       ;vyvoleny radek
        TCH_AKTIV       DB      ?       ;priznak aktivace
        TCH_REZB        DB      ?
        TCH_REZ         DW  3 DUP (?)
        TCH_FILENAME    DB 16 DUP (?)   ;nazev souboru
        TCH_DATA        DD      ?       ;datova oblast
TAB_TECHNOLS    ENDS

;.....................

;Pro PLC obrazovky

STCH_IN_HEADS	struc
	STCH_IN_HEAD_SIZE	DW	0
	STCH_REQ_NUM1		DB	0	;cislo obrazovky z 1.sady (1,2,..16)
	STCH_REQ_NUM2		DB	0	;cislo obrazovky z 2.sady (1,2,..16)
	STCH_REQ_NUM3		DB	0	;cislo obrazovky z 3.sady (1,2,..16)
	STCH_REQ1		DB	0	;aktivace obrazovky z 1.sady (0,1,..,5)
	STCH_REQ2		DB	0	;aktivace obrazovky z 2.sady (0,1,..,5)
	STCH_REQ3		DB	0	;aktivace obrazovky z 3.sady (0,1,..,5)
	STCH_DATA_VALID1	DB	0	;platnost dat od PLC pro 1.sadu
	STCH_DATA_VALID2	DB	0	;platnost dat od PLC pro 2.sadu
	STCH_DATA_VALID3	DB	0	;platnost dat od PLC pro 3.sadu
	STCH_ENABLE1		DB	0	;zpusoby povoleni zobrazovani pro 1.sadu
	STCH_ENABLE2		DB	0	;zpusoby povoleni zobrazovani pro 2.sadu
	STCH_ENABLE3		DB	0	;zpusoby povoleni zobrazovani pro 3.sadu
	STCH_EDIT_REQ		DB	0	;povoleni edice pro 1.sadu
	STCH_DATA_ACK		DB	0	;PLC potvrdi prevzeti polozky 
	STCH_IN_REZER		DB 16 DUP (0)
STCH_IN_HEADS	ends

STCH_OUT_HEADS	struc
	STCH_OUT_HEAD_SIZE	DW	0
	STCH_ACT_NUM1		DB	0	;cislo prave zobrazovane obrazovky z 1.sady (1,2,..16)
	STCH_ACT_NUM2		DB	0	;cislo prave zobrazovane obrazovky z 2.sady (1,2,..16)
	STCH_ACT_NUM3		DB	0	;cislo prave zobrazovane obrazovky z 3.sady (1,2,..16)
	STCH_EDIT_ACK		DB	0	;edituje se 
	STCH_EDIT_BUSY_ITEM	DW	0	;prave editovana polozka
	STCH_EDIT_NEW_ITEM	DW	0	;polozka, ktera ma novou hodnotu
	STCH_OUT_REZER		DB 22 DUP (0)
STCH_OUT_HEADS	ends

;.....................

;Struktura pro tocitko s displejem

TOC_DISPLS	struc
	TOC_ROW			DB	0	;radek
	TOC_COLUMN		DB	0	;sloupec
	TOC_CHAR1		DB	0	;1.znak
	TOC_CHAR2		DB	0	;2.znak
	TOC_CHAR3		DB	0	;3.znak
	TOC_CHAR4		DB	0	;4.znak
TOC_DISPLS	ends

;.....................

;Struktura pro rizeni osciloskopu
ifdef _KEY_OSCIL
CHANNELS	struc
	CHANN_CONTROL_1		DB	0	;rizeni 0=default
	CHANN_CONTROL_2		DB	0
	CHANN_WEIGHT_1		DB	0	;vaha bitu(1,2,..80h), nebo 0=WORD,09h=BYTE
	CHANN_WEIGHT_2		DB	0
	CHANN_STANDARD_1	DW	0	;preddefinovane vzory
	CHANN_STANDARD_2	DW	0
	CHANN_OFFSET_1		DD	0	;offset pro 1.paprsek	
	CHANN_OFFSET_2		DD	0	;offset pro 2.paprsek
	CHANN_OFFSET_1_DEF	DD	0	;offset pro 1.paprsek - default	
	CHANN_OFFSET_2_DEF	DD	0	;offset pro 2.paprsek - default
CHANNELS	ends

;Zaznam dat
OSCRECORD 	struc
	OSCREC_1	DD	0;
	OSCREC_2	DD	0;
	OSCREC_3	DD	0;
	OSCREC_4	DD	0;
	OSCREC_5	DD	0;
	OSCREC_6	DD	0;
	OSCREC_7	DD	0;
	OSCREC_8	DD	0;
	OSCREC_9	DD	0;
	OSCREC_10	DD	0
	OSCTTRIGG	DB	0;		;Prizank prichodu "Capture"
	OSCPOSTTRIGG	DB	0;		;Konec zaznamu po prichodu
	OSCREZ		DB 6 DUP (0)		;Rezerva
OSCRECORD     ends


endif
;.....................

sync1r RECORD  HOLD_STOP:1,RAMP_STOP:1,ACK_STOP:1,REQ_STOP:1

sync2r RECORD ?REQ_BACKUP_TRANS:1,?REQ_SAVE_PLC:1,?REQ_BACKUP_MEM:1,?REQ_BACKUP_POS:1,?REQ_CLOSE_ALL:1,?REQ_PIS_HALT:1
  REQ_BACKUP_TRANS	equ	contr_sync_2
  REQ_SAVE_PLC		equ	contr_sync_2
  REQ_BACKUP_MEM	equ	contr_sync_2
  REQ_BACKUP_POS	equ	contr_sync_2
  REQ_CLOSE_ALL		equ	contr_sync_2
  REQ_PIS_HALT		equ	contr_sync_2

sync3r RECORD ?ACT_BACKUP_POS:1,?RES_BACKUP_POS:1

trans_all_len	equ 	trans_rezer_end - TRANS_FLAT1_STATUS	;celkova delka

;.....................

bzh_enh1r RECORD  ?LIMIT_FEED_G00_REQ:1,?LIMIT_FEED_REQ:1,?BUSY_DISPTOC2:1,?BUSY_DISPTOC1:1,?PRESET_TOC_CLR:1,?NCPAN_TOC_DIS:1,?EXPAN_TOC_DIS:1,?SPEED_OVR:1
SPEED_OVR	equ	BZH_ENH1
NCPAN_TOC_DIS	equ	BZH_ENH1
EXPAN_TOC_DIS	equ	BZH_ENH1
PRESET_TOC_CLR	equ	BZH_ENH1
BUSY_DISPTOC1	equ	BZH_ENH1
BUSY_DISPTOC2	equ	BZH_ENH1
LIMIT_FEED_REQ	equ	BZH_ENH1
LIMIT_FEED_G00_REQ equ	BZH_ENH1

pb_enh1r RECORD  ???pbenh7:1,?AUTMAN_INKR:1,?MOVE_REVERSE:1,?AUTMAN_SEL_QMAN:1,?AUTMAN_SEL_TOC:1,?AUTMAN_SEL_MAN:1,?SYNTAX_TB:1,?G23ACT:1
AUTMAN_SEL_TOC	equ	PB_ENH1
AUTMAN_SEL_MAN	equ	PB_ENH1
AUTMAN_SEL_QMAN	equ	PB_ENH1
G23ACT		equ	PB_ENH1
SYNTAX_TB	equ	PB_ENH1
MOVE_REVERSE	equ	PB_ENH1
AUTMAN_INKR     equ     PB_ENH1

pb_enh2r RECORD	???pbenh15:1,???pbenh14:1,???pbenh13:1,???pbenh12:1,???pbenh11:1,???pbenh10:1,?BLOCK_KILL_AFT:1,?BLOCK_KILL_ACT:1
BLOCK_KILL_ACT	equ	PB_ENH2
BLOCK_KILL_AFT	equ	PB_ENH2


; *** Pro UPS

UPS_CMDR 	RECORD ?__UPS_REZ_CMD2_7:7,?UPS_SHUTDOWN:1
UPS_SHUTDOWN	equ 	UPS_CMD

UPS_SYSR 	RECORD ?__UPS_REZ_SYS2_7:5,?UPS_OFFD:1,?UPS_POOL:1,?UPS_COMRDY:1
UPS_COMRDY	equ 	UPS_SYS
UPS_POOL	equ	UPS_SYS		;Dotaz
UPS_OFFD	equ	UPS_SYS		;Byl povel pro vypnuti

UPS_FAULTR 	RECORD ?__UPS_REZ_FLT2_7:6,?UPS_ERRINT:1,?UPS_ERRCOM:1
UPS_ERRCOM	equ	UPS_FAULT	;Error COM2
UPS_ERRINT	equ	UPS_FAULT	;Error interruptu na COM2

UPS_STATR	RECORD	?UPS_OFF:1,?__UPS_ST6:1,?UPS_OVER:1,?__UPS_ST4:1,?UPS_BOOST:1,?__UPS_ST2:1,?UPS_BATLOW:1,?UPS_LINEFAIL:1
UPS_OFF		equ	UPS_STAT
UPS_OVER	equ	UPS_STAT
UPS_BOOST	equ	UPS_STAT
UPS_BATLOW	equ	UPS_STAT
UPS_LINEFAIL	equ	UPS_STAT

; *** Pro SCAN

SCAN_SAVER	RECORD ?__SCAN_REZ1_37:4,?SCAN_SAVE_ERR:1,?SCAN_SAVE_ACT:1,?SCAN_SAVE_STOP:1,?SCAN_SAVE_START:1
SCAN_RESTORER	RECORD ?__SCAN_REZ2_37:4,?SCAN_RESTORE_ERR:1,?SCAN_RESTORE_ACT:1,?SCAN_RESTORE_STOP:1,?SCAN_RESTORE_START:1
SCAN_SAVE_START		equ	SCAN_SAVE
SCAN_SAVE_STOP		equ	SCAN_SAVE	
SCAN_SAVE_ACT		equ	SCAN_SAVE
SCAN_SAVE_ERR		equ	SCAN_SAVE
SCAN_RESTORE_START	equ	SCAN_RESTORE
SCAN_RESTORE_STOP	equ	SCAN_RESTORE
SCAN_RESTORE_ACT	equ	SCAN_RESTORE
SCAN_RESTORE_ERR	equ	SCAN_RESTORE

;Struktura pro zaznam SCAN
SCAN_RECORDS	STRUC
	SCANREC_BLOK		DB 0			;priznak novy blok
	SCANREC_REZ		DB 3 DUP (0)
	SCANREC_COUNT_BLOK	DD 0			;cislo bloku
	SCANREC_DATA		DD 3 DUP (0)		;data
SCAN_RECORDS	ENDS


;*** Pro AKRR

AKRR_CNTRR	RECORD ?__AKRR_REZ:2,?EXT_AKRR_SUPORT:1,?EXT_AKRR_REQ:1,?EXT_AKRR_VCORR:1,?EXT_AKRR_DIST:1,?EXT_AKRR_SMAX:1,?EXT_AKRR_V:1
EXT_AKRR_V		equ	AKRR_CNTR
EXT_AKRR_SMAX		equ	AKRR_CNTR
EXT_AKRR_DIST		equ	AKRR_CNTR
EXT_AKRR_VCORR		equ	AKRR_CNTR
EXT_AKRR_REQ		equ	AKRR_CNTR
EXT_AKRR_SUPORT 	equ	AKRR_CNTR

;.....................


;**** Pro rizeni COVERFEED

covers	RECORD CNT_COV_ACT:1,CNT_COV_EN:1,CNT_COV_RDY:1,CNT_COV_KNF:1
;CNT_COV_ACT ...        cover-feed aktivni
;CNT_COV_EN ....	dle stroj.konstanty 2.R338
;CNT_COV_RDY ...	zaznam COVER je hotov
;CNT_COV_KNF ...	dle KNF57=2


tcovers RECORD R_??2C:1,R_??1C:1,R_VERZE_COVER:1,R_COVERS_X:1,R_COVERS_S:1,R_GRAFS_X:1,R_GRAFS_P:1,R_GRAFS_S:1
;R_GRAFS_S ...		typ struktury ZAZNAM_GRAFS standard
;R_GRAFS_P ...		typ struktury ZAZNAM_GRAFS palici
;R_COVERS_S ...		typ struktury ZAZNAM_COVER standard
;R_VERZE_COVER ... 	verze struktur

;.....................

;**** Pro SLM *****
EncoderObject           EQU 19 
MotorObject             EQU 49 
DriveType               EQU 61440 - 65536 
WriteEprom              EQU 40960 - 65536 
WriteDisable            EQU 32768 - 65536 
WriteEnable             EQU 38912 - 65536 
DriveStatusWord         EQU -32768 
DriveFaultWord          EQU 53248-65536 
DataAckSlm2             EQU 0 
DataNackSlm2            EQU 1 
CommandAckSlm2          EQU 2 
DataAckSlm3             EQU 3 
DataNackSlm3            EQU 4 
CommandAckSlm3          EQU 5 
DataAckSlmHigh          EQU 126 
EEpromDataAck           EQU 32256 
EEpromCmdAck            EQU 32258 
ReadEprom               EQU 49152 - 65536 
EEpromAddress           EQU 38 
DataReceived            EQU 32 

SlmAxisData     STRUC
SlmPID1                 DW 97       ;PID(1) 1.sada
SlmPID2                 DW 1347     ;PID(2)
SlmPID3                 DW 240      ;PID(3)
SlmPID4                 DW 91       ;PID(4)
SlmPID5                 DW -2589    ;PID(5)
SlmPID6                 DW 5521     ;PID(6)
SlmPID1B                DW 97       ;PID(1) 2.sada
SlmPID2B                DW 1347     ;PID(2)
SlmPID3B                DW 240      ;PID(3)
SlmPID4B                DW 91       ;PID(4)
SlmPID5B                DW -2589    ;PID(5)
SlmPID6B                DW 5521     ;PID(6)
SlmPID1C                DW 97       ;PID(1) 3.sada
SlmPID2C                DW 1347     ;PID(2)
SlmPID3C                DW 240      ;PID(3)
SlmPID4C                DW 91       ;PID(4)
SlmPID5C                DW -2589    ;PID(5)
SlmPID6C                DW 5521     ;PID(6)
SlmFilter               DW -14045   ;Filter
SlmBuffNum		DW 0       
SlmEEpromEncoder        DW (EncoderObject+1) DUP (?) 
SlmEEpromMotor          DW (MotorObject-EncoderObject+1) DUP (?) 
Slmdata                 DW ?
SlmDriveCurrentRating   DW ?
SlmDriveType            DW ?
SlmMaxSpeed             DW ?
SlmCurrentScaling       DW ?
SlmI2tTreshold          DW ?
SlmZeroOffset           DW ?
SlmZeroFlags            DW ?
SlmSWVer		DW 0
SlmI                    DW ?
SlmX                    DW ?
SlmY                    DW ?
SlmBoard                DW ?
SlmCmdHeader            DB ?
SlmDataAck              DB ?
SlmCmdAck               DB ?
SlmCommand              DB ?
SlmAddress              DB ?
SlmCrcMask              DB ?
SlmAttempt              DB ?
SlmTemp1                DB ?
SlmTemp2                DB ?
SlmFiller               DB ?
SlmPeakCurrentLimit	DW ?
SlmMaxSpeedMul		DW ?
SlmRezerva		DW 18 DUP (0)
SlmAxisData     ENDS

;.....................

;**** Pro rizeni transformace souradnic

ifdef _KEY_TRANS
transs	RECORD  TR_??7:1,TR_??6:1,TR_??5:1,TR_??4:1,TR_??3:1,?TR_RESTORE:1,?TR_SET:1,?TR_ENABLE:1

transp		struc			;parametry zadani
	trans_param_a1	DD	0	;vektor a
	trans_param_a2	DD	0
	trans_param_a3	DD	0
	trans_param_i	DD	0	;uhel ALFA
	trans_param_j	DD	0	;uhel BETA
	trans_param_k	DD	0	;uhel GAMA
transp		ends

matrix22	struc			;matice 2x2
	matrix22_a11	DT	0	;1.radek
	matrix22_a12	DT	0
	matrix22_a21	DT	0	;2.radek
	matrix22_a22	DT	0
matrix22	ends	
		
matrix33	struc			;matice 3x3
	matrix33_a11	DT	0	;1.radek
	matrix33_a12	DT	0
	matrix33_a13	DT	0
	matrix33_a21	DT	0	;2.radek
	matrix33_a22	DT	0
	matrix33_a23	DT	0
	matrix33_a31	DT	0	;3.radek
	matrix33_a32	DT	0
	matrix33_a33	DT	0
matrix33	ends	

matrix13	struc			;sloupcovy vektor
	matrix13_a1	DT	0	;1.radek
	matrix13_a2	DT	0	;2.radek
	matrix13_a3	DT	0	;3.radek
matrix13	ends	
endif
;.....................


_?ERR_KOD_INOUT	= 1
IO_ER_HLI_ACT		EQU	ERR_KOD_INOUT	;bit0 = chyba vystpu HI/LI dle ERR_INOUT (okamzity - jen cist) 
IO_ER_TM_ACT		EQU	ERR_KOD_INOUT	;bit1 = time-out (okamzity - jen cist)
IO_ER_HLI		EQU	ERR_KOD_INOUT	;bit2 = chyba vystpu HI/LI dle ERR_INOUT (pamet	-nuluje	uzivatel)
IO_ER_TMOUT		EQU	ERR_KOD_INOUT	;bit3 = time-out (pamet	- nuluje uzivatel)
E_IOR RECORD ???EI7:1,???EI6:1,???EI5:1,???EI4:1,?IO_ER_TMOUT:1,?IO_ER_HLI:1,?IO_ER_TM_ACT:1,?IO_ER_HLI_ACT:1

_?CONTROL_INOUT	= 1
IO_DIS_ERR		EQU	CONTROL_INOUT	;bit0 = blokovani vypisu chyb vystupu	
IO_DIS_ERPIS		EQU	CONTROL_INOUT	;bit1 = blokovani chyb vystupu pro PLC 
IO_DIS_TMOUT		EQU	CONTROL_INOUT	;bit2 = blokovani chyb time-out
IO_FAST_REQ		EQU	CONTROL_INOUT	;bit3 = povel aktivace rychlych	reakci IP0/OP0
IO_FAST_ACK		EQU	CONTROL_INOUT	;bit4 = potvrzeni aktivace rychlych reakci IP0/OP0
IO_INIT			EQU	CONTROL_INOUT	;bit5 = inicializace INOUT07
C_IOR RECORD ???CI7:1,???CI6:1,?IO_INIT:1,?IO_FAST_ACK:1,?IO_FAST_REQ:1,?IO_DIS_TMOUT:1,?IO_DIS_ERPIS:1,?IO_DIS_ERR:1

;Pro PLC jednotky
MAX_PLC_UNIT		EQU 15			;Pocet PLC modulu:  E003 - E017
DIST_PLC_UNIT		EQU 10000H		;Rozestup modulu PLC

;--------------------------------------------------

;STRUKTURY PRO SOUBOROVOU SPRAVU

ifdef _KEY_FILES
max_filereq	EQU	10		;Maximalni pocet pozadavku
max_filereq_sec	EQU	 8		;Maximalni pocet pozadavku pro sec  proc.
max_filereq_bsp	EQU	 2		;Maximalni pocet pozadavku pro prim proc.


FS_ERR_OK_END		EQU	 1 	;Bez chyb, bylo dosazeno konce souboru
FS_ERR_OK		EQU	 0	;Bez chyb
FS_ERR_UNKNOWN		EQU	-1	;Nespecifik.chyba
FS_ERR_INVALIDHANDLE	EQU	-2	;Neplatny handle
FS_ERR_INVALIDFROM	EQU	-3	;Chyba zdroje, soubor/cesta neexistuje
FS_ERR_INVALIDTO	EQU	-4	;Chyba cile, cesta neexistuje
FS_ERR_INVALIDPATH	EQU	-5	;Cesta neexistuje
FS_ERR_ALREADYEXIST	EQU	-6	;Adresar se zad.jmenem existuje
FS_ERR_NOTEMTY		EQU	-7	;Adresar neni prazdny
FS_ERR_READ		EQU	-8	;Chyba pro cetni souboru
FS_ERR_WRITE		EQU	-9	;Chyba pro zapisu do souboru
FS_ERR_SETTIME		EQU	-10	;Nepodarilo se nastavit cas

FS_READ			EQU	1	;Otevrit pro cteni
FS_WRITE		EQU	2	;Otevrit pro zapis
FS_CREATE		EQU	4	;V pripade ze existuje, vytvorit znovu


;CloseHandle
CLOSEHANDLES	struc
  CloseHandle_Busy	DB	0	;Platnost dat
  CloseHandle_Disable	DB	0	;
  CloseHandle_hObject	DD	0	;Handle souboru = primo hodnota
  CloseHandle_hEvent	DD	0	;Handle udalosti 
  CloseHandle_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  CloseHandle_Time	DW	0	;Time
  CloseHandle_Date	DW	0	;Date
CLOSEHANDLES	ends

;CopyFile
COPYFILES	struc
  CopyFile_Busy		DB	0	;Platnost dat
  CopyFile_Disable	DB	0
  CopyFile_lpFrom	DD	0	;Jmeno souboru zdroje vcetne cesty
  CopyFile_lpTo		DD	0	;Jmeno souboru cile vcetne cesty
  CopyFile_hEvent	DD	0	;Handle udalosti 
  CopyFile_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  CopyFile_Reser2	DD	0	;Rezerva
COPYFILES	ends

;CreateDirectory
CREATEDIRS	struc
  CreateDir_Busy	DB	0	;Platnost dat
  CreateDir_Disable	DB	0
  CreateDir_lpPathName	DD	0	;Jmeno adresare
  CreateDir_hEvent	DD	0	;Handle udalosti	 
  CreateDir_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  CreateDir_Reser2	DD	0	;Rezerva
CREATEDIRS	ends

;CreateDirList
CREATDIRLSTS	struc
  CreatDirLst_Busy	DB	0	;Platnost dat
  CreatDirLst_Disable	DB	0
  CreatDirLst_lpFile	DD	0	;Jmeno souboru s cestou a znaku *, ?
  CreatDirLst_hEvent	DD	0	;Handle udalosti	 
  CreatDirLst_lphDirLst	DD	0	;Handle otevreneho souboru s vypisem	 
  CreatDirLst_lpSize	DD	0	;Delka souboru (pokud neni ukazatel =0)(stejna jako DIRLISTS_dwSize)	 
  CreatDirLst_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  CreatDirLst_Reser2	DD	0	;Rezerva
CREATDIRLSTS	ends

;CreateFile
CREATEFILES	struc
  CreateFile_Busy	DB	0	;Platnost dat
  CreateFile_Disable	DB	0	;
  CreateFile_lpFileName	DD	0	;Ukazatel na jmeno souboru vcetne cesty
  CreateFile_Flags	DD	0	;Zpusob rizeni pristupu (1=FS_READ, 2=FS_WRITE, 4=FS_CREATE)
  CreateFile_hEvent	DD	0	;Handle udalosti
  CreateFile_lphFile	DD	0	;Ukazatel pro ulozeni handle souboru
  CreateFile_lpSize	DD	0	;Delka souboru pri otevreni (pokud neni ukazatel=0)
  CreateFile_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  CreateFile_Reser2	DD	0	;Rezerva
CREATEFILES	ends

;DeleteFile
DELETEFILES	struc
  DeleteFile_Busy	DB	0	;Platnost dat
  DeleteFile_Disable	DB	0	;
  DeleteFile_lpFileName	DD	0	;Ukazatel na jmeno souboru vcetne cesty
  DeleteFile_hEvent	DD	0	;Handle udalosti
  DeleteFile_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  DeleteFile_Reser2	DD	0	;Rezerva
DELETEFILES	ends

;GetFileInfo
GETFILEINFOS	struc
  GetFileInfo_Busy	DB	0	;Platnost dat
  GetFileInfo_Disable	DB	0	;
  GetFileInfo_lpFile    DD	0	;Ukazatel na jmeno souboru vcetne cesty
  GetFileInfo_hEvent	DD	0	;Handle udalosti
  GetFileInfo_lpFInfo   DD	0	;Informace o souboru FILEINFO
  GetFileInfo_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  GetFileInfo_Reser2	DD	0	;Rezerva
GETFILEINFOS	ends

;ReadFile
READFILES	struc
  ReadFile_Busy		DB	0	;Platnost dat
  ReadFile_Disable	DB	0	;
  ReadFile_hFile	DD	0	;Handle souboru = primo hodnota
  ReadFile_lpGetAsync	DD	0	;Ukazatel na strukturu GetAsync
  ReadFile_lpLarge	DD	0	;Fyzicky ukazatel na buffer, kam se ulozi nactena data
  ReadFile_hEvent	DD	0	;Handle udalosti
  ReadFile_Reser2	DD	0	;Rezerva
READFILES	ends

;RemoveDir
REMOVEDIRS	struc
  RemoveDir_Busy	DB	0	;Platnost dat
  RemoveDir_Disable	DB	0	;
  RemoveDir_lpPathName	DD	0	;Jmeno adresare ktery se ma smazat
  RemoveDir_hEvent	DD	0	;Handle udalosti
  RemoveDir_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  RemoveDir_Reser2	DD	0	;Rezerva
REMOVEDIRS	ends

;MoveFile
MOVEFILES	struc
  MoveFile_Busy		DB	0	;Platnost dat
  MoveFile_Disable	DB	0	;
  MoveFile_lpFrom	DD	0	;Jmeno souboru
  MoveFile_lpTo		DD	0	;Jmeno cile
  MoveFile_hEvent	DD	0	;Handle udalosti
  MoveFile_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  MoveFile_Reser2	DD	0	;Rezerva
MOVEFILES	ends

;SetFileTime
SETFILETIMES	struc
  SetFileTime_Busy	DB	0	;Platnost dat
  SetFileTime_Disable	DB	0	;
  SetFileTime_hFile	DD	0	;Handle na soubor
  SetFileTime_dwFTime	DW	0	;Cas	
  SetFileTime_dwFDate	DW	0	;Datum
  SetFileTime_hEvent	DD	0	;Handle udalosti
  SetFileTime_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  SetFileTime_Reser2	DD	0	;Rezerva
SETFILETIMES	ends


;GetFileTime
GETFILETIMES	struc
  GetFileTime_Busy	DB	0	;Platnost dat
  GetFileTime_Disable	DB	0	;
  GetFileTime_hFile	DD	0	;Handle na soubor
  GetFileTime_lpFTime	DD	0	;Ukazatel kde nastavit cas	
  GetFileTime_lpFDate	DD	0	;Ukazatel kde nastavit datum
  GetFileTime_hEvent	DD	0	;Handle udalosti
  GetFileTime_lpResult	DD	0	;Ukazatel pro ulozeni vysledku volani
  GetFileTime_Reser2	DD	0	;Rezerva
GETFILETIMES	ends


;WriteFile
WRITEFILES	struc
  WriteFile_Busy	DB	0	;Platnost dat
  WriteFile_Disable	DB	0	;
  WriteFile_hFile	DD	0	;Handle souboru = primo hodnota
  WriteFile_lpPutAsync	DD	0	;Ukazatel na strukturu PutAsync
  WriteFile_lpLarge	DD	0	;Fyzicky ukazatel na buffer, kam se ulozi nactena data
  WriteFile_hEvent	DD	0	;Handle udalosti
  WriteFile_Reser2	DD	0	;Rezerva
WRITEFILES	ends

;Struktura pro zapis do souboru
FSPUTASYNC	struc
  FSPUTASYNC_wDataLen	DW	0	;Pocet dat na ktere ukazuje lpBuf (pozadovana delka dat)  
  FSPUTASYNC_lpData	DD	0	;Ukazatel na data, ketre se maji zapsat do souboru  
  FSPUTASYNC_hEvent	DD	0	;Handle udalsti
  FSPUTASYNC_chResult	DB	0	;Vysledek operace
  FSPUTASYNC_dwReserved	DD	0	;Libovolna pouziti
FSPUTASYNC	ends

;Struktura pro cteni ze souboru
FSGETASYNCS	struc
  FSGETASYNC_wDataLen	DW	0	;Sem se ulozi pocet nactenych dat (skutecne nactena data)  
  FSGETASYNC_wBufSize	DW	0	;Delka bufferu na ktery ukazuje lpBuf (pozadovana delka dat)
  FSGETASYNC_lpBuf	DD	0	;Ukazatel na buffer, kam se ulozi nactena data
  FSGETASYNC_hEvent	DD	0	;Handle udalsti
  FSGETASYNC_chResult	DB	0	;Vysledek operace
  FSGETASYNC_dwReserved	DD	0	;Libovolna pouziti
FSGETASYNCS	ends

;Informace o souboru pro funkci GetFileInfo
FILEINFOS	struc
  FILEINFO_wSize	DW	0	;velkost struktury
  FILEINFO_fDirectory	DD	0	;TRUE pro adresar
  FILEINFO_FTime	DW	0	;Cas vytvoreni
  FILEINFO_FDate	DW	0	;Datum
  FILEINFO_dwSize	DD	0	;Velkost souboru
  FILEINFO_AltFileName	DB 14 DUP (0)	;Kratke jmeno souboru
  FILEINFO_FileName	DB 14 DUP (0)	;Dlouhe jmeno souboru (MAX_FNAME)
FILEINFOS	ends

;Struktura k prenosu vypisu adresare
DIRLISTS	struc
  DIRLIST_dwSize	DD	0	;Celkova velkost vypisu
  DIRLIST_wFileCount	DW	0	;Pocet prvku FILEINFO
; DIRLIST_FirstFileInfo FILEINFOS <(0)> ;Pole prvku FILEINFO 
DIRLISTS	ends

endif

;Struktury pro zjisteni casu a datumu
TIME_INFOS	struc
  TIME_MIN		DB	0	;Minuty
  TIME_HOUR		DB	0	;Hodiny
  TIME_HUND		DB	0	;Setiny sekundy
  TIME_SEC		DB	0	;Sekundy
TIME_INFOS	ends  

DATE_INFOS	struc
  DATE_YEAR		DW	0	;Rok - 1980
  DATE_DAY		DB	0	;Den
  DATE_MON		DB	0	;Mesic
DATE_INFOS	ends  


;Struktura pro rizeni vleceni z PLC
TRAILS		struc			;delka 4 BYTE
  TRAIL_ACTIV		DB	0	;aktivacni a modifikacni signal (1=vleceni, 2=vlec.zrcadleni)
  TRAIL_MASTER		DB	0	;ridici osa 1,2,3,...
  TRAIL_MODIF		DW	0	;modifikace (rezerva)
TRAILS		ends


;Struktura pro sdileni adresaru
len_PATHSHARES_Path	EQU 48
len_PATHSHARES_Name	EQU 16

PATHSHARES	struc
  PATHSHARES_Path	DB len_PATHSHARES_Path DUP (0)
  PATHSHARES_Name	DB len_PATHSHARES_Name DUP (0)
PATHSHARES	ends


;Errory pro potenciometry
ERR_POT_SYS	EQU	70      ;chyba obsluhy potenciometru
ERR_POT_AINP	EQU	71      ;chyba v identifikaci pot.
ERR_POT_PORT	EQU	72      ;neplatne cislo kanalu
ERR_POT_KNF 	EQU	74      ;nepodporovana konfigurace

;...........................

;Struktury pro udalosti EVENT

;Organizace pameti Event po 32 byte (20h)
EVENTS	struc
   EVENTS_HOUR		DB 0		;hodiny (busy)
   EVENTS_MIN		DB 0		;minuty
   EVENTS_SEC		DB 0		;sekundy
   EVENTS_NAME  	DB 8 DUP  (0)	;nazev udalosti na 8.pozici je klic
   EVENTS_DESC		DB 21 DUP (0)	;popis udalosti
EVENTS  ends
LEN_MEM_EVENT	EQU  100000h


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;Pro Windows
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;Definice zadosti o modifikace rezimu pro Windows
REQM_BlockByBlock	equ	1	;zadost o modifikaci BB	
REQM_CondStop		equ	2	;zadost o rezim M01


;Definice pro AUT-BB
BB_Enable		equ	1	;BB povolen
BB_Active		equ	2	;BB aktivni
BB_Start		equ	4	;na dlasi blok

;Ruzne flagy pro BLOK - bunka BLOCK_FLAGS
BFLG_BLOCKFINISHED	equ	1	;pro BLOCKFINISHED


;Definice statusu pro Windows
;Konstanty RTSF_... (Real Time Status Flags) definuj pznaky pro rzn stavy modulu relnho asu.
RTSF_RUN		equ	1	;"Systm v chodu" (stroj "jede", a/nebo jsou provdny technologick funkce)
RTSF_BLOCKINPROGR	equ	2	;Blok rozpracovn
RTSF_BLOCKFINISHED	equ	4	;Blok ukoncen
RTSF_STOP		equ	8	;Stop - vechny bloky dokoneny (RTSF_BLOCKINPROGR nen nastaveno), nebo vykonvn perueno (RTSF_BLOCKINPROGR nastaveno)
RTSF_INPOS		equ	16	;Bylo dosaeno poadovan polohy (dn osa nejede a diference pro vechny osy klesla pod zadanou mez).
RTSF_DELAYINPROGR	equ	32	;asov prodleva - po dobu prodlevy programovan funkc G04.
RTSF_INDICATIONMODE	equ	64	;Indikan reim
RTSF_SIMULATIONMODE	equ	128	;Simulan reim ("jedn bez hardwaru")
RTSF_HIGHSPEEDMODE	equ	256	;Zrychlen reim
RTSF_CONDSTOP		equ	512	;Podmnny stop aktivn (pro bloky s M01)
RTSF_MANUALMODE		equ 	1024	;Manuln reim ("pomocn run pojezdy)
RTSF_BLOCKBYBLOCK	equ	2048	;Reim blok po bloku



; Struktura RECREFERENCE obsahuje informace potebn pro proveden reference.


BLK_RECREFERENCS STRUC
	Ref_eType		DD	0		;Zpsob proveden reference
	BLK_dwRefAxisMask	DB	0
				DB 3 DUP (0)
	wRefAxisMaskREC		RECORD ?BLK_RefAxis5:1,?BLK_RefAxis4:1,?BLK_RefAxis3:1,?BLK_RefAxis2:1,?BLK_RefAxis1:1,?BLK_RefAxis0:1
BLK_RECREFERENCS ENDS


;~~~~~~~~~~

;Pro strukturu SECRECBLOKS

G_GROUPS_COUNT	EQU	12	;Poet skupin G funkc (0 a 11)
M_GROUPS_COUNT	EQU	15	;Poet skupin M funkc (0 a 14, skupina 0 se nevyuv
MAX_NCAXES	EQU	6	;Max. mon poet interpolovanch os
MAX_POSAXES	EQU	3	;Max. mon poet polohovacch os (ovldan z NCP, interpolovny samostatn)


;Typ interpolace
BLK_itNoInterpolation	equ	0	;enum INTERPOLATIONTYPE
BLK_itRapidTraverse	equ	1
BLK_itLinear		equ	2
BLK_itCircleCW		equ	3
BLK_itCircleCCW		equ	4
BLK_itThread		equ	5


;Vet enum RECBLOCKTYPE definuje zkladn typy blok (zznamu).
BLK_btAut		equ	0	;"Automatick" reim - bn blok ze zznamu
BLK_btAutIns		equ	1	;"Automatick" reim - dodaten vloen blok, nevznik na zklad komprimovan formy
BLK_btCAnul		equ	2	;Blok centrln anulace - obsahuje pouze funkce z prioritnho bloku
BLK_btRef		equ	3	;Blok njezdu do reference - obsahuje pouze informace o referenci


;Zaznamy pro strukturu SECRECBLOCKS

	;BLK_AddrProgr
dwAddrProgrREC	RECORD  ?BLK_bHProgr:1

	; Zmnov bity pro jednotliv skupiny M funkc.
dwMProgrREC	RECORD	?BLK_bM7:1,?BLK_bM6:1,?BLK_bM5:1,?BLK_bM4:1,?BLK_bM3:1,?BLK_bM2:1,?BLK_bM1:1,?BLK_bM0:1		
dwMProgr2REC	RECORD	?BLK_bM14:1,?BLK_bM13:1,?BLK_bM12:1,?BLK_bM11:1,?BLK_bM10:1,?BLK_bM9:1,?BLK_bM8:1		

	; Modifikace
dwModeProgrREC	RECORD 	?BLK_bConstCutSpeed:1,?BLK_bRevolutionSpeed:1,?BLK_bContinuousMode:1

	; Pznaky pohybu pro jednotliv NC osy
dwNCMoveProgrREC	RECORD ?BLK_bAxNC5Move:1,?BLK_bAxNC4Move:1,?BLK_bAxNC3Move:1,?BLK_bAxNC2Move:1,?BLK_bAxNC1Move:1,?BLK_bAxNC0Move:1			

	; Informace o tom, kter osy se maj zahrnout do vpotu rychlosti
dwNCPathProgrREC	RECORD	?BLK_bAxNC5Path:1,?BLK_bAxNC4Path:1,?BLK_bAxNC3Path:1,?BLK_bAxNC2Path:1,?BLK_bAxNC1Path:1,?BLK_bAxNC0Path:1

	; Informace pro interpoltor - itThread
dwThreadProgrREC	RECORD ?BLK_bRunOut:1,?BLK_bRunIn:1			

	; Pznaky pohybu pro jednotliv polohovaci osy
dwAxPosMoveREC		RECORD	?bAxPos2Move:1,?bAxPos1Move:1,?bAxPos0Move:1

	; Priznaky zacatku a konce bloku
dwBlkFlags		RECORD	?bCondStop:1,?bStop:1,?bLastBlock:1,?bFirstBlock:1

;~~~~~~~~~~

; Struktura SECRECBLOCK tvo jeden blok zznamu ppravy partprogramu. 

SECRECBLOCKS	STRUC

			; Ponter bloku ze zaznamu

		BLK_lpBlock	DD	0


			;Typ bloku

		BLK_eBlockType	DB	0	;enum RECBLOCKTYPE  (btAut/btAutIns/btCAnul/btRef)
				DB 3 DUP (0)

			; Priznaky
		BLK_dwFlags	DB 0		;RECORD dwBlkFlags  (bLastBlock/bFirstBlock/bStop/bCondStop)
				DB 3 DUP (0)
				
			; Programovan hodnoty jednotlivch adres (vechny adresy 

		BLK_rH		DQ	0			;CNCREAL Programovan hodnota adresy H 


			; Zmnov bity adres

		BLK_dwAddrProgr	DB 	0	;RECORD dwAddrProgrREC
				DB 3 DUP (0)


			; Programovan M funkce jednotlivch skupin

		BLK_iM		DD 	M_GROUPS_COUNT DUP (0)	;CNCINT  Programovan M funkce jednotlivch skupin


			; Zmnov bity pro jednotliv skupiny M funkc.

		BLK_dwMProgr	DB	0	;RECORD dwMProgrREC
		BLK_dwMProgr2	DB	0	;RECORD dwMProgr2REC
				DB 2 DUP (0)


			; Rzn pznaky pro jzdu

		BLK_dwModeProgr	DB	0	;RECORD dwModeProgrREC
				DB 3 DUP (0)


			;Typ interpolace

		BLK_eInterpolationType DB	0	;enum INTERPOLATIONTYPE
				DB 3 DUP (0)

		
			; asov prodleva programovan v bloku

		BLK_rDelay		DQ	0	;CNCREAL



			; Informace pro interpoltor - itRapidTraverse/itLinear/itThread

		BLK_rAxNCInc		DQ MAX_NCAXES DUP (0)	;CNCREAL Prstkov vyjden bloku


			
			; Pznaky pohybu pro jednotliv NC osy
	
		BLK_dwNCMoveProgr	DB	0	;RECORD dwNCMoveProgrREC
					DB 3 DUP (0)
		

			; Informace o tom, kter osy se maj zahrnout do vpotu rychlosti
			; (1 - path axes, 0 - synchronized axes)

		BLK_dwNCPathProgr	DB	0	;RECORD dwNCPathProgrREC
					DB 3 DUP (0)


			; Informace pro interpoltor - itCircleCW/itCircleCCW

		BLK_rVectorC1		DQ 2 DUP (0)		;CNCREAL Vektor sted - poten bod krunice (dv souadnice - podle iAxis1 a iAxis2)
		BLK_rVectorC2		DQ 2 DUP (0)		;CNCREAL Vektor sted - koncov bod
		BLK_iRevCount		DD	0		;CNCINT Poet "otek" ( 0: mn ne 360, 1: <360, 720), 2: <720, 1080), ... )
		BLK_iAxis1		DD	0		;CNCINT slo prvn osy - udv interpolan rovinu
		BLK_iAxis2		DD	0		;CNCINT slo druhe osy - udv interpolan rovinu
		BLK_bHelix		DD	0		;BOOL TRUE - vytven roubovice (pid se pojezd v ose uveden v iSpiralAxis)
		BLK_rSpiralPitch	DQ	0		;CNCREAL Stoupn roubovice (mm/ot)
		BLK_iSpiralAxis		DD	0		;CNCINT slo osy pro roubovici




			; Informace pro interpoltor - itThread
			; (Vbh zvitu = runout = gewindeauslauf)
		BLK_dwThreadProgr	DB	0	;RECORD dwThreadProgrREC
					DB 3 DUP (0)


		BLK_rThreadRunInLen	DQ	0		;CNCREAL Dlka njezdu zvitu
		BLK_rThreadRunInAngle	DQ	0		;CNCREAL hel njezdu zvitu
		BLK_rThreadRunOutLen	DQ	0		;CNCREAL Dlka vjezdu zvitu
		BLK_rThreadRunOutAngle	DQ	0		;CNCREAL hel vjezdu zvitu



			; Polohovac osy - prstkov vyjden drhy polohovacch souadnic

		BLK_rAxPosInc		DQ MAX_POSAXES DUP (0)	;CNCREAL 


			; Pznaky pohybu polohovacich os

		BLK_dwAxPosMove		DB	0		;RECORD dwAxPosMoveREC
					DB 3 DUP (0)


			; Rychlosti

		BLK_rSpeedProgr		DQ	0		;CNCREAL Programovan rychlost bloku
		BLK_rSpeedMax		DQ	0		;CNCREAL Maximln rychlost bloku (linerka - rychlost rychloposuvu, kruhovka:
								;            min(rychlost rychloposuvu, rychlost odvozen z max. odstedivho zrychlen) )
		BLK_rSpeedCriterial	DQ	0		;CNCREAL Kriteriln rychlost na zatku bloku (max. ppustn rychlost na zatku bloku, spote se na 
								;zklad zadanch kritri (poadovan pesnost, max. peten stroje) a geometrie tohoto 
								;a pedchozho bloku (prostorov hel, dlka blok, ...)


			; Veteno
	
		BLK_rSpindleSpeed	DQ	0		;CNCREAL Otky vetene (ot/min)
		BLK_rSpindleSpeedLimit	DQ	0		;CNCREAL Limit otek vetene pro konstantn eznou rychlost
		BLK_rConstCuttingSpeed	DQ	0		;CNCREAL Rychlost pro reim konstantn ezn rychlosti




			; Reference
		BLK_Reference	BLK_RECREFERENCS <(0)>
		

SECRECBLOCKS	ENDS

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;Pro vazbu bitu na umisteni ve strukture
;ve Wintechnolu by mely byt pristupy: 
;   LDR bActualBlock+BLK_dwAllProgr.BLK_bExcl   nebo   LDR bActualBlock+BLK_bExcl.BLK_bExcl
;   LOD DWRD.bActualBlock+BLK_iExcl             nebo   LOD DWRD.ActualBlock.BLK_iExcl	

bActualBlock 	equ	BYTE PTR ActualBlock

BLK_bExcl	equ	BLK_dwAllProgr
BLK_bF		equ	BLK_dwAllProgr
BLK_bH		equ	BLK_dwAllProgr
BLK_bL		equ	BLK_dwAllProgr
BLK_bR		equ	BLK_dwAllProgr
BLK_bS		equ	BLK_dwAllProgr
BLK_bT		equ	BLK_dwAllProgr

BLK_bG0		equ	BLK_dwGProgr
BLK_bG1		equ	BLK_dwGProgr
BLK_bG2		equ	BLK_dwGProgr
BLK_bG3		equ	BLK_dwGProgr
BLK_bG4		equ	BLK_dwGProgr
BLK_bG5		equ	BLK_dwGProgr
BLK_bG6		equ	BLK_dwGProgr
BLK_bG7		equ	BLK_dwGProgr
BLK_bG8		equ	BLK_dwGProgr2
BLK_bG9		equ	BLK_dwGProgr2
BLK_bG10	equ	BLK_dwGProgr2
BLK_bG11	equ	BLK_dwGProgr2

BLK_bM0		equ	BLK_dwMProgr
BLK_bM1		equ	BLK_dwMProgr
BLK_bM2		equ	BLK_dwMProgr
BLK_bM3		equ	BLK_dwMProgr
BLK_bM4		equ	BLK_dwMProgr
BLK_bM5		equ	BLK_dwMProgr
BLK_bM6		equ	BLK_dwMProgr
BLK_bM7		equ	BLK_dwMProgr
BLK_bM8		equ	BLK_dwMProgr2
BLK_bM9		equ	BLK_dwMProgr2
BLK_bM10	equ	BLK_dwMProgr2
BLK_bM11	equ	BLK_dwMProgr2
BLK_bM12	equ	BLK_dwMProgr2
BLK_bM13	equ	BLK_dwMProgr2
BLK_bM14	equ	BLK_dwMProgr2

BLK_bA		equ	BLK_dwAddrProgr
BLK_bB		equ	BLK_dwAddrProgr
BLK_bC		equ	BLK_dwAddrProgr
BLK_bI		equ	BLK_dwAddrProgr
BLK_bJ		equ	BLK_dwAddrProgr
BLK_bK		equ	BLK_dwAddrProgr
BLK_bO		equ	BLK_dwAddrProgr
BLK_bP		equ	BLK_dwAddrProgr
BLK_bQ		equ	BLK_dwAddrProgr2
BLK_bU		equ	BLK_dwAddrProgr2
BLK_bV		equ	BLK_dwAddrProgr2
BLK_bW		equ	BLK_dwAddrProgr2
BLK_bX		equ	BLK_dwAddrProgr2
BLK_bY		equ	BLK_dwAddrProgr2
BLK_bZ		equ	BLK_dwAddrProgr2

BLK_bContinuousMode 	equ BLK_dwModeProgr
BLK_bRevolutionSpeed	equ BLK_dwModeProgr
BLK_bConstCutSpeed	equ BLK_dwModeProgr
BLK_bIncrementalProgr	equ BLK_dwModeProgr

BLK_bProgrTransformation	equ BLK_dwTransModeProgr

BLK_bAxNC0Move	equ	BLK_dwNCMoveProgr
BLK_bAxNC1Move	equ	BLK_dwNCMoveProgr
BLK_bAxNC2Move	equ	BLK_dwNCMoveProgr
BLK_bAxNC3Move	equ	BLK_dwNCMoveProgr
BLK_bAxNC4Move	equ	BLK_dwNCMoveProgr
BLK_bAxNC5Move	equ	BLK_dwNCMoveProgr

BLK_bAxNC0Path	equ	BLK_dwNCPathProgr
BLK_bAxNC1Path	equ	BLK_dwNCPathProgr
BLK_bAxNC2Path	equ	BLK_dwNCPathProgr
BLK_bAxNC3Path	equ	BLK_dwNCPathProgr
BLK_bAxNC4Path	equ	BLK_dwNCPathProgr
BLK_bAxNC5Path	equ	BLK_dwNCPathProgr

BLK_bRunIn	equ	BLK_dwZavitProgr
BLK_bRunOut	equ	BLK_dwZavitProgr


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



;--------------------------------------------------
;$DCOM_BEGIN

DATA_COM SEGMENT PARA COMMON USE16 'CODE'
data_com_begin		DW	3	;verze komunikacni oblasti DCOM.ASH
					;+ verze souboru HARD.ASH a PROT.ASH !!
					;(cislo	se musi	zmenit pri libovolne 
					; zmene	s techto 3 souboru ) 

;...........................

DMAFLADDR		point_f	 <(0)>	;adresa	flagu z	rezidentu (musi	byt offset 2 !)

;...........................

HALT_STATUS_MEM		DW	0	;pricina haltu secondary
ERR_INT			DW	0	;nezname cislo int v secondary
ACK_INT			DW	0	;aktualni cislo	int v secondary
TEPLY_START		DB	0	;pouzit	jen byte
SEC_READY		DB	0	;sec. proc ready
BUSY_BSP		DW	0	;flag BSP (55ms)
BUSY_SEC		DW	0	;flag SEC (20ms)
ADDR_PROCNUM_BSP	DW	offset DATA_COM:PROCNUM_BSP
ADDR_PROCNUM_SEC	DW	offset DATA_COM:PROCNUM_SEC
TIM_APIC_SEC		DD	0	;pro nastaveni casovace
IOTYPE			DB	0	;0ffh pro PCI CDIST
SU5TYPE			DB	0	;82h nebo 84h

;...........................

CNF_SEC_BASE	SEC_KNFS <>	;Konfigurace secondary

;...........................

begin_zaznam_bsp	DD	0	;zacatek zaznamu BSP
timer_mem_sec		DD	0
com1_mem_sec		DD	0

;...............

contr_sync_1	sync1r	<0,0,0,0>
;...............

contr_sync_2	sync2r	<0,0,0,0,0>  ;pridavat nove pred _SAVE..

;...............

contr_sync_3	sync3r	<0,0>	    ;vnitrni po presunu B_POL(INK) -> B_POL_BACKUP

;...............

contr_cover 	covers	<0,0,0>     ;rizeni coverfeed
  
type_cover	tcovers <0,0,0,0>   ;typ struktur cover	

				;rezerva 1 byte

ALIGN 16
B_POLOHA	DD  6 DUP (0)	;KONTROLNI POLOHA
N_BLOCK_ACT     DD      0       ;AKTUALNI BLOK

;...........................

;Konfigurace pro PCI karty

ALIGN 16
PCI_HEAD		BOARDS	<>
PCI_BDVER		CONFS	32  DUP	 (<?>)

;...........................

;Ridici	struktury komunikace

ALIGN 16
SEC_TO_BSP KTOS	<(OFFSET DATA_COM:BFIFO),(OFFSET DATA_COM:BFIFO_END),(OFFSET DATA_COM:BFIFO),0,0>

ALIGN 16
BSP_TO_SEC KTOS	<(OFFSET DATA_COM:RFIFO),(OFFSET DATA_COM:RFIFO_END),(OFFSET DATA_COM:RFIFO),0,0>

;Komunikacni oblast SEC -> BSP

ALIGN 16
BFIFO		DB 3000	DUP (0)
BFIFO_END	DB   16	DUP (0)

;............................

;Komunikacni oblast BSP -> SEC

ALIGN 16
RFIFO		DB 3000	DUP (0)
RFIFO_END	DB   16	DUP (0)

;............................

; 1.Komunikacni	oblast D M A,  P C I  (8+8 slave)

HOTOVO		dw 0	;Semafor pro vymenu dat od 8 zarizeni DMA
			;value 1 oznamuje ze je naplnen vystupni buffer
			;program po prevzeti tento bit musi nulovat
		
;Definice vstupniho dataveho pole pro DMA

datain0	db 8 dup (0)	;vstupni data pro tocitko (slave=0)	*** KANAL - A ***	  
datain1	db 8 dup (0)	;vstupni data pro tlacitka (slave=1)
datain2	db 8 dup (0)	;INOUT07 (slave=2) JP1=1  1.R231 bit0 matice
datain3	db 8 dup (0)	;INOUT07 (slave=3) JP1=2  2.R231 bit0 TLOUT-P2OUT
datain4	db 8 dup (0)	;INOUT07 (slave=4) JP1=3  3.R231 bit0 P3OUT-P5OUT
datain5	db 8 dup (0)	;INOUT07 (slave=5) JP1=4  4.R231 bit0 P6OUT-P8OUT
datain6	db 8 dup (0)	;INOUT07 (slave=6) JP1=5  5.R231 bit0 P9OUT-P11OUT
datain7	db 8 dup (0)	;INOUT07 (slave=7) JP1=6  6.R231 bit0 P12OUT-P14OUT

datain8	 db 8 dup (0)	;vstupni data pro tocitko (slave=0)		*** KANAL - B ***
datain9	 db 8 dup (0)	;vstupni data pro tlacitka (slave=1)
datain10 db 8 dup (0)  	;INOUT07 (slave=2) JP1=1  1.R231 bit1 matice
datain11 db 8 dup (0)  	;INOUT07 (slave=3) JP1=2  2.R231 bit1 P15OUT - P17OUT
datain12 db 8 dup (0)  	;INOUT07 (slave=4) JP1=3  3.R231 bit1 P18OUT - P20OUT
datain13 db 8 dup (0)  	;INOUT07 (slave=5) JP1=4  4.R231 bit1 P21OUT - P23OUT
datain14 db 8 dup (0)  	;INOUT07 (slave=6) JP1=5  5.R231 bit1 P24OUT - P26OUT
datain15 db 8 dup (0)	;INOUT07 (slave=7) JP1=6  6.R231 bit1 P27OUT - P29OUT


;Definice vystupniho datoveho pole pro DMA
dataout0  db 10 dup (0)	;TOCITKO  (slave=0)			*** KANAL - A ***
dataout1  db 10 dup (0)	;TLACITKA (slave=1)  +9=vazne chyby
dataout2  db 10 dup (0)	;INOUT07 (slave=2) JP1=1  1.R231 bit0 matice
dataout3  db 10 dup (0)	;INOUT07 (slave=3) JP1=2  2.R231 bit0 P1IN-P4IN
dataout4  db 10 dup (0)	;INOUT07 (slave=4) JP1=3  3.R231 bit0 P5IN-P8IN
dataout5  db 10 dup (0)	;INOUT07 (slave=5) JP1=5  4.R231 bit0 P9IN-P12IN
dataout6  db 10 dup (0)	;INOUT07 (slave=6) JP1=6  5.R231 bit0 P13IN-P16IN
dataout7  db 10 dup (0)	;INOUT07 (slave=7) JP1=7  6.R231 bit0 P17IN-P20IN

dataout8  db 10 dup (0)	;TOCITKO  (slave=0)			*** KANAL - B ***
dataout9  db 10 dup (0)	;TLACITKA (slave=1)  +9=vazne chyby
dataout10 db 10 dup (0)	;INOUT07 (slave=2) JP1=1  1.R231 bit1 matice
dataout11 db 10 dup (0)	;INOUT07 (slave=3) JP1=2  2.R231 bit1 P21IN - P24IN
dataout12 db 10 dup (0)	;INOUT07 (slave=4) JP1=3  3.R231 bit1 P25IN - P28IN
dataout13 db 10 dup (0)	;INOUT07 (slave=5) JP1=5  4.R231 bit1 P29IN - P32IN
dataout14 db 10 dup (0)	;INOUT07 (slave=6) JP1=6  5.R231 bit1 P33IN - P36IN
dataout15 db 10 dup (0)	;INOUT07 (slave=7) JP1=7  6.R231 bit1 P37IN - P40IN

SYS_ERR	    DW  16 DUP (0)	;ukladani chyb ze seriove linky	(interrupt)
TAB_STATUS  DB  16 DUP (0)	;tabulka adres statusu odpovedi	(interrupt)
CIT_INOUT   DB  16 DUP (0)	;citac chyb
ERR_INOUT   DB  16 DUP (0)	;podskupina chyb (chyba vyvodu 1,2,...,48)

ERR_KOD_INOUT	DB  16 DUP (0) 
   ;bit0 (IO_ER_HLI_ACT)	= chyba vystpu HI/LI dle ERR_INOUT (okamzity - jen cist) 
   ;bit1 (IO_ER_TM_ACT)	        = time-out (okamzity - jen cist)
   ;bit2 (IO_ER_HLI)		= chyba vystpu HI/LI dle ERR_INOUT (pamet -nuluje uzivatel)
   ;bit3 (IO_ER_TMOUT)	        = time-out (pamet - nuluje uzivatel)

CONTROL_INOUT	DB  16 DUP (0)
   ;bit0 (IO_DIS_ERR)	= blokovani vypisu chyb vystupu	  
   ;bit1 (IO_DIS_ERPIS)	= blokovani chyb vystupu pro PLC 
   ;bit2 (IO_DIS_TMOUT)	= blokovani chyb time-out
   ;bit3 (IO_FAST_REQ)	= povel aktivace rychlych reakci IP0/OP0
   ;bit4 (IO_FAST_ACK)	= aktivni rychle reakce
   ;bit5 (IO_INIT)	= inicializace INOUT07

				
FAST_K1_INOUT	DB  16 DUP (0)	;priznaky K1 pro rychle reakce
FAST_K2_INOUT	DB  16 DUP (0)	;priznaky K2 pro rychle reakce
FAST_K3_INOUT	DB  16 DUP (0)	;priznaky K3 pro rychle reakce

FL_SET_DMA	DW 0		;aktivace slave
FL_TEST_DMA	DW 0		;pro rizeni TIME-OUT v 55ms
FL_TEST2_DMA	DW 0
FL_TEST3_DMA	DW 0

;**** Sejmute vstupy z perif. jednotek IOUT07 DMA v secondary *** KANAL-A ***

PANEL_STROJE   DB 8 DUP	(0)       ;MATICE  (slave=2) JP1=1  1.R231 bit0  

P1IN	    DB	0    ;1.PORT   IP0 INOUT07 (slave=3) JP1=2   2.R231 bit0 
P2IN	    DB	0    ;2.PORT   IP1
P3IN	    DB	0    ;3.PORT   IP2
P4IN	    DB	0    ;4.PORT   IP3

P5IN	    DB	0    ;5.PORT   IP0 INOUT07 (slave=4) JP1=3   3.R231 bit0  
P6IN	    DB	0    ;6.PORT   IP1
P7IN	    DB	0    ;7.PORT   IP2
P8IN	    DB	0    ;8.PORT   IP3

P9IN	    DB	0    ;9.PORT   IP0 INOUT07 (slave=5) JP1=4   4.R231 bit0  
P10IN	    DB	0    ;10.PORT IP1
P11IN	    DB	0    ;11.PORT IP2
P12IN	    DB	0    ;12.PORT IP3

P13IN	    DB	0    ;13.PORT IP0 INOUT07 (slave=6) JP1=5   5.R231 bit0   
P14IN	    DB	0    ;14.PORT IP1
P15IN	    DB	0    ;15.PORT IP2
P16IN	    DB	0    ;16.PORT IP3

P17IN	    DB	0    ;17.PORT IP0 INOUT07 (slave=7) JP1=6   6.R231 bit0  
P18IN	    DB	0    ;18.PORT IP1
P19IN	    DB	0    ;19.PORT IP2
P20IN	    DB	0    ;20.PORT IP3

;**** Sejmute vstupy z perif. jednotek IOUT07 DMA v secondary *** KANAL-B ***

PANEL_STROJE2   DB 8 DUP	(0)    ;MATICE      (slave=2) JP1=1  1.R231  

P21IN	    DB	0    ;21.PORT IP0 INOUT07 (slave=3) JP1=2   2.R231 bit1	 
P22IN	    DB	0    ;22.PORT IP1
P23IN	    DB	0    ;23.PORT IP2
P24IN	    DB	0    ;24.PORT IP3

P25IN	    DB	0    ;25.PORT IP0 INOUT07 (slave=4) JP1=3   3.R231 bit1  
P26IN	    DB	0    ;26.PORT IP1
P27IN	    DB	0    ;27.PORT IP2
P28IN	    DB	0    ;28.PORT IP3

P29IN	    DB	0    ;29.PORT IP0 INOUT07 (slave=5) JP1=4   4.R231 bit1  
P30IN	    DB	0    ;30.PORT IP1
P31IN	    DB	0    ;31.PORT IP2
P32IN	    DB	0    ;32.PORT IP3

P33IN	    DB	0    ;33.PORT IP0 INOUT07 (slave=6) JP1=5   5.R231 bit1  
P34IN	    DB	0    ;34.PORT IP1
P35IN	    DB	0    ;35.PORT IP2
P36IN	    DB	0    ;36.PORT IP3

P37IN	    DB	0    ;37.PORT IP0 INOUT07 (slave=7) JP1=6    6.R231 bit1  
P38IN	    DB	0    ;38.PORT IP1
P39IN	    DB	0    ;39.PORT IP2
P40IN	    DB	0    ;40.PORT IP3


;**** Vystupy na perif. jednotky IOUT07 DMA v secondary *** KANAL-A ***

TLOUTM	    DB	0    ;1.PORT   OP0 INOUT07 (slave=2) JP1=1  1.R231 bit0

P0OUT	    DB	0    ;2.PORT   OP0 INOUT07 (slave=3) JP1=2  2.R231 bit0 
P1OUT	    DB	0    ;3.PORT   OP1
P2OUT	    DB	0    ;4.PORT   OP2

P3OUT	    DB	0    ;5.PORT   OP0 INOUT07 (slave=4) JP1=3  3.R231 bit0
P4OUT	    DB	0    ;6.PORT   OP1
P5OUT	    DB	0    ;7.PORT   OP2

P6OUT	    DB	0    ;8.PORT   OP0 INOUT07 (slave=5) JP1=4  4.R231 bit0
P7OUT	    DB	0    ;9.PORT   OP1
P8OUT	    DB	0    ;10.PORT OP2

P9OUT	    DB	0    ;11.PORT OP0 INOUT07 (slave=6) JP1=5  5.R231 bit0
P10OUT	    DB	0    ;12.PORT OP1
P11OUT	    DB	0    ;13.PORT OP2

P12OUT	    DB	0    ;14.PORT OP0 INOUT07 (slave=7) JP1=6  6.R231 bit0
P13OUT	    DB	0    ;15.PORT OP1
P14OUT	    DB	0    ;16.PORT OP2

TLOUT 	    EQU P0OUT 

;*** Ridici vystupy pro rychle reakce "control port" **** KANAL-A *****
C0OUT	    DB	0    ;control port CP0
C3OUT	    DB	0    ;control port CP3
C6OUT	    DB	0    ;control port CP6
C9OUT	    DB	0    ;control port CP9
C12OUT	    DB	0    ;control port CP12

;*** Indikace vystupu z INOUT07 pro rychle reakce  **** KANAL-A ***** 
VI0OUT	    DB	0    ;vystup pro control port CP0
VI3OUT	    DB	0    ;vystup pro control port CP3
VI6OUT	    DB	0    ;vystup pro control port CP6
VI9OUT	    DB	0    ;vystup pro control port CP9
VI12OUT	    DB	0    ;vystup pro control port CP12


;**** Vystupy na perif. jednotky IOUT07 DMA v secondary *** KANAL-B ***

TLOUTM2    DB	0    ;17.PORT OP0 INOUT07 (slave=2) JP1=1  1.R231 bit1

P15OUT	    DB	0    ;18.PORT OP0 INOUT07 (slave=3) JP1=2  2.R231 bit1 
P16OUT	    DB	0    ;19.PORT OP1
P17OUT	    DB	0    ;20.PORT OP2

P18OUT	    DB	0    ;21.PORT OP0 INOUT07 (slave=4) JP1=3  3.R231 bit1
P19OUT	    DB	0    ;22.PORT OP1
P20OUT	    DB	0    ;23.PORT OP2

P21OUT	    DB	0    ;24.PORT OP0 INOUT07 (slave=5) JP1=4  4.R231 bit1
P22OUT	    DB	0    ;25.PORT OP1
P23OUT	    DB	0    ;26.PORT OP2

P24OUT	    DB	0    ;27.PORT OP0 INOUT07 (slave=6) JP1=5  5.R231 bit1
P25OUT	    DB	0    ;28.PORT OP1
P26OUT	    DB	0    ;29.PORT OP2

P27OUT	    DB	0    ;30.PORT OP0 INOUT07 (slave=7) JP1=6  6.R231 bit1
P28OUT	    DB	0    ;31.PORT OP1
P29OUT	    DB	0    ;32.PORT OP2


;*** Ridici vystupy pro rychle reakce "control port" **** KANAL-B *****
C15OUT	    DB	0    ;control port CP15
C18OUT	    DB	0    ;control port CP18
C21OUT	    DB	0    ;control port CP21
C24OUT	    DB	0    ;control port CP24
C27OUT	    DB	0    ;control port CP27


;*** Indikace vystupu z INOUT07 pro rychle reakce  **** KANAL-B ***** 
VI15OUT	    DB	0    ;vystup pro control port CP15
VI18OUT	    DB	0    ;vystup pro control port CP18
VI21OUT	    DB	0    ;vystup pro control port CP21
VI24OUT	    DB	0    ;vystup pro control port CP24
VI27OUT	    DB	0    ;vystup pro control port CP27



;*** Hlaseni chyb vystupu HIGH-IMPED a LOW-IMPED = utrzeni privod / zkrat ***KANAL-A***
;PLC program musi prislusne bity po prevzeti vynulovat

ERRHI_TLOUTM	DB	0    ;1.PORT	OP0 INOUT07 (slave=2) JP1=1  1.R231 
ERRLI_TLOUTM	DB	0    ;1.PORT	OP0 INOUT07 (slave=2) JP1=1  1.R231 

ERRHI_P0OUT	DB	0    ;2.PORT	OP0 INOUT07 (slave=3) JP1=2  2.R231 
ERRHI_P1OUT	DB	0    ;3.PORT	OP1
ERRHI_P2OUT	DB	0    ;4.PORT	OP2
		DB	0    
ERRLI_P0OUT	DB	0    ;2.PORT	OP0 INOUT07 (slave=3) JP1=2  2.R231 
ERRLI_P1OUT	DB	0    ;3.PORT	OP1
ERRLI_P2OUT	DB	0    ;4.PORT	OP2
		DB	0    

ERRHI_P3OUT	DB	0    ;5.PORT	OP0 INOUT07 (slave=4) JP1=3  3.R231 
ERRHI_P4OUT	DB	0    ;6.PORT	OP1
ERRHI_P5OUT	DB	0    ;7.PORT	OP2
		DB	0    
ERRLI_P3OUT	DB	0    ;5.PORT	OP0 INOUT07 (slave=4) JP1=3  3.R231 
ERRLI_P4OUT	DB	0    ;6.PORT	OP1
ERRLI_P5OUT	DB	0    ;7.PORT	OP2
		DB	0    

ERRHI_P6OUT	DB	0    ;8.PORT	OP0 INOUT07 (slave=5) JP1=4  4.R231 
ERRHI_P7OUT	DB	0    ;9.PORT	OP1
ERRHI_P8OUT	DB	0    ;10.PORT	OP2
		DB	0    
ERRLI_P6OUT	DB	0    ;8.PORT	OP0 INOUT07 (slave=5) JP1=4  4.R231 
ERRLI_P7OUT	DB	0    ;9.PORT	OP1
ERRLI_P8OUT	DB	0    ;10.PORT	OP2
		DB	0    

ERRHI_P9OUT	DB	0    ;11.PORT	OP0 INOUT07 (slave=6) JP1=5  5.R231 
ERRHI_P10OUT	DB	0    ;12.PORT	OP1
ERRHI_P11OUT	DB	0    ;13.PORT	OP2
		DB	0    
ERRLI_P9OUT	DB	0    ;11.PORT	OP0 INOUT07 (slave=6) JP1=5  5.R231 
ERRLI_P10OUT	DB	0    ;12.PORT	OP1
ERRLI_P11OUT	DB	0    ;13.PORT	OP2
		DB	0    

ERRHI_P12OUT	DB	0    ;14.PORT	OP0 INOUT07 (slave=7) JP1=6  6.R231 
ERRHI_P13OUT	DB	0    ;15.PORT	OP1
ERRHI_P14OUT	DB	0    ;16.PORT	OP2
		DB	0    
ERRLI_P12OUT	DB	0    ;14.PORT	OP0 INOUT07 (slave=7) JP1=6  6.R231 
ERRLI_P13OUT	DB	0    ;15.PORT	OP1
ERRLI_P14OUT	DB	0    ;16.PORT	OP2
		DB	0    

ERRHI_TLOUT 	equ 	ERRHI_P0OUT 
ERRLI_TLOUT 	equ 	ERRLI_P0OUT 


;*** Hlaseni chyb vystupu HIGH-IMPED a LOW-IMPED = utrzeni privod / zkrat ***KANAL-B***
;PLC program musi prislusne bity po prevzeti vynulovat

ERRHI_TLOUTM2	DB	0    ;17.PORT	OP0 INOUT07 (slave=2) JP1=1  1.R231 
ERRLI_TLOUTM2	DB	0    ;17.PORT	OP0 INOUT07 (slave=2) JP1=1  1.R231 

ERRHI_P15OUT	DB	0    ;18.PORT	OP0 INOUT07 (slave=3) JP1=2  2.R231 
ERRHI_P16OUT	DB	0    ;19.PORT	OP1
ERRHI_P17OUT	DB	0    ;20.PORT	OP2
		DB	0    
ERRLI_P15OUT	DB	0    ;18.PORT	OP0 INOUT07 (slave=3) JP1=2  2.R231 
ERRLI_P16OUT	DB	0    ;19.PORT	OP1
ERRLI_P17OUT	DB	0    ;20.PORT	OP2
		DB	0    

ERRHI_P18OUT	DB	0    ;21.PORT	OP0 INOUT07 (slave=4) JP1=3  3.R231 
ERRHI_P19OUT	DB	0    ;22.PORT	OP1
ERRHI_P20OUT	DB	0    ;23.PORT	OP2
		DB	0    
ERRLI_P18OUT	DB	0    ;21.PORT	OP0 INOUT07 (slave=4) JP1=3  3.R231 
ERRLI_P19OUT	DB	0    ;22.PORT	OP1
ERRLI_P20OUT	DB	0    ;23.PORT	OP2
		DB	0    

ERRHI_P21OUT	DB	0    ;24.PORT	OP0 INOUT07 (slave=5) JP1=4  4.R231 
ERRHI_P22OUT	DB	0    ;25.PORT	OP1
ERRHI_P23OUT	DB	0    ;26.PORT	OP2
		DB	0    
ERRLI_P21OUT	DB	0    ;24.PORT	OP0 INOUT07 (slave=5) JP1=4  4.R231 
ERRLI_P22OUT	DB	0    ;25.PORT	OP1
ERRLI_P23OUT	DB	0    ;26.PORT	OP2
		DB	0    

ERRHI_P24OUT	DB	0    ;27.PORT	OP0 INOUT07 (slave=6) JP1=5  5.R231 
ERRHI_P25OUT	DB	0    ;28.PORT	OP1
ERRHI_P26OUT	DB	0    ;29.PORT	OP2
		DB	0    
ERRLI_P24OUT	DB	0    ;27.PORT	OP0 INOUT07 (slave=6) JP1=5  5.R231 
ERRLI_P25OUT	DB	0    ;28.PORT	OP1
ERRLI_P26OUT	DB	0    ;29.PORT	OP2
		DB	0    

ERRHI_P27OUT	DB	0    ;30.PORT	OP0 INOUT07 (slave=7) JP1=6  6.R231 
ERRHI_P28OUT	DB	0    ;31.PORT	OP1
ERRHI_P29OUT	DB	0    ;32.PORT	OP2
		DB	0    
ERRLI_P27OUT	DB	0    ;30.PORT	OP0 INOUT07 (slave=7) JP1=6  6.R231 
ERRLI_P28OUT	DB	0    ;31.PORT	OP1
ERRLI_P29OUT	DB	0    ;32.PORT	OP2
		DB	0    

;--------------------------------------------------

;*** DEKLARACE PRO PLC PRO VSTUPY A VYSTUPY DMA	***

_?TAB_STATUS	= 1
_?CIT_INOUT	= 1
_?ERR_INOUT	= 1

_?FAST_K1_INOUT	= 1
IO_K1_0		EQU	FAST_K1_INOUT
IO_K1_1		EQU	FAST_K1_INOUT
IO_K1_2		EQU	FAST_K1_INOUT
IO_K1_3		EQU	FAST_K1_INOUT
IO_K1_4		EQU	FAST_K1_INOUT
IO_K1_5		EQU	FAST_K1_INOUT
IO_K1_6		EQU	FAST_K1_INOUT
IO_K1_7		EQU	FAST_K1_INOUT
K1_IOR RECORD ?IO_K1_7:1,?IO_K1_6:1,?IO_K1_5:1,?IO_K1_4:1,?IO_K1_3:1,?IO_K1_2:1,?IO_K1_1:1,?IO_K1_0:1

_?FAST_K2_INOUT	= 1
IO_K2_0		EQU	FAST_K2_INOUT
IO_K2_1		EQU	FAST_K2_INOUT
IO_K2_2		EQU	FAST_K2_INOUT
IO_K2_3		EQU	FAST_K2_INOUT
IO_K2_4		EQU	FAST_K2_INOUT
IO_K2_5		EQU	FAST_K2_INOUT
IO_K2_6		EQU	FAST_K2_INOUT
IO_K2_7		EQU	FAST_K2_INOUT
K2_IOR RECORD ?IO_K2_7:1,?IO_K2_6:1,?IO_K2_5:1,?IO_K2_4:1,?IO_K2_3:1,?IO_K2_2:1,?IO_K2_1:1,?IO_K2_0:1

_?FAST_K3_INOUT	= 1
IO_K3_0		EQU	FAST_K3_INOUT
IO_K3_1		EQU	FAST_K3_INOUT
IO_K3_2		EQU	FAST_K3_INOUT
IO_K3_3		EQU	FAST_K3_INOUT
IO_K3_4		EQU	FAST_K3_INOUT
IO_K3_5		EQU	FAST_K3_INOUT
IO_K3_6		EQU	FAST_K3_INOUT
IO_K3_7		EQU	FAST_K3_INOUT
K3_IOR RECORD ?IO_K3_7:1,?IO_K3_6:1,?IO_K3_5:1,?IO_K3_4:1,?IO_K3_3:1,?IO_K3_2:1,?IO_K3_1:1,?IO_K3_0:1

;nealokovany zaznam
IO_IOR RECORD  ?IO_7:1,?IO_6:1,?IO_5:1,?IO_4:1,?IO_3:1,?IO_2:1,?IO_1:1,?IO_0:1

_?PANEL_STROJE	= 1
_?PANEL_STROJE2	= 1

_?P1IN		= 1
_?P2IN		= 1
_?P3IN		= 1
_?P4IN		= 1
_?P5IN		= 1
_?P6IN		= 1
_?P7IN		= 1
_?P8IN		= 1
_?P9IN		= 1
_?P10IN		= 1
_?P11IN		= 1
_?P12IN		= 1
_?P13IN		= 1
_?P14IN		= 1
_?P15IN		= 1
_?P16IN		= 1
_?P17IN		= 1
_?P18IN		= 1
_?P19IN		= 1
_?P20IN		= 1

_?P21IN		= 1
_?P22IN		= 1
_?P23IN		= 1
_?P24IN		= 1
_?P25IN		= 1
_?P26IN		= 1
_?P27IN		= 1
_?P28IN		= 1
_?P29IN		= 1
_?P30IN		= 1
_?P31IN		= 1
_?P32IN		= 1
_?P33IN		= 1
_?P34IN		= 1
_?P35IN		= 1
_?P36IN		= 1
_?P37IN		= 1
_?P38IN		= 1
_?P39IN		= 1
_?P40IN		= 1

_?TLOUTM	= 1
_?TLOUT		= 1
_?P1OUT		= 1
_?P2OUT		= 1
_?P3OUT		= 1
_?P4OUT		= 1
_?P5OUT		= 1
_?P6OUT		= 1
_?P7OUT		= 1
_?P8OUT		= 1
_?P9OUT		= 1
_?P10OUT	= 1
_?P11OUT	= 1
_?P12OUT	= 1
_?P13OUT	= 1
_?P14OUT	= 1
_?P0OUT		= 1 

_?TLOUTM2	= 1
_?P15OUT	= 1
_?P16OUT	= 1
_?P17OUT	= 1
_?P18OUT	= 1
_?P19OUT	= 1
_?P20OUT	= 1
_?P21OUT	= 1
_?P22OUT	= 1
_?P23OUT	= 1
_?P24OUT	= 1
_?P25OUT	= 1
_?P26OUT	= 1
_?P27OUT	= 1
_?P28OUT	= 1
_?P29OUT	= 1

_?ERRHI_TLOUTM	= 1
_?ERRLI_TLOUTM	= 1
_?ERRHI_TLOUT	= 1
_?ERRHI_P1OUT	= 1
_?ERRHI_P2OUT	= 1
_?ERRLI_TLOUT	= 1
_?ERRLI_P1OUT	= 1
_?ERRLI_P2OUT	= 1
_?ERRHI_P3OUT	= 1
_?ERRHI_P4OUT	= 1
_?ERRHI_P5OUT	= 1
_?ERRLI_P3OUT	= 1
_?ERRLI_P4OUT	= 1
_?ERRLI_P5OUT	= 1
_?ERRHI_P6OUT	= 1
_?ERRHI_P7OUT	= 1
_?ERRHI_P8OUT	= 1
_?ERRLI_P6OUT	= 1
_?ERRLI_P7OUT	= 1
_?ERRLI_P8OUT	= 1
_?ERRHI_P9OUT	= 1
_?ERRHI_P10OUT	= 1
_?ERRHI_P11OUT	= 1
_?ERRLI_P9OUT	= 1
_?ERRLI_P10OUT	= 1
_?ERRLI_P11OUT	= 1
_?ERRHI_P12OUT	= 1
_?ERRHI_P13OUT	= 1
_?ERRHI_P14OUT	= 1
_?ERRLI_P12OUT	= 1
_?ERRLI_P13OUT	= 1
_?ERRLI_P14OUT	= 1
_?ERRHI_P0OUT	= 1
_?ERRLI_P0OUT	= 1
_?C0OUT		= 1
_?C3OUT		= 1
_?C6OUT		= 1 
_?C9OUT		= 1 
_?C12OUT	= 1

_?ERRHI_TLOUTM2 = 1
_?ERRLI_TLOUTM2 = 1
_?ERRHI_P15OUT	= 1
_?ERRHI_P16OUT	= 1
_?ERRHI_P17OUT	= 1
_?ERRLI_P15OUT	= 1
_?ERRLI_P16OUT	= 1
_?ERRLI_P17OUT	= 1
_?ERRHI_P18OUT	= 1
_?ERRHI_P19OUT	= 1
_?ERRHI_P20OUT	= 1
_?ERRLI_P18OUT	= 1
_?ERRLI_P19OUT	= 1
_?ERRLI_P20OUT	= 1
_?ERRHI_P21OUT	= 1
_?ERRHI_P22OUT	= 1
_?ERRHI_P23OUT	= 1
_?ERRLI_P21OUT	= 1
_?ERRLI_P22OUT	= 1
_?ERRLI_P23OUT	= 1
_?ERRHI_P24OUT	= 1
_?ERRHI_P25OUT	= 1
_?ERRHI_P26OUT	= 1
_?ERRLI_P24OUT	= 1
_?ERRLI_P25OUT	= 1
_?ERRLI_P26OUT	= 1
_?ERRHI_P27OUT	= 1
_?ERRHI_P28OUT	= 1
_?ERRHI_P29OUT	= 1
_?ERRLI_P27OUT	= 1
_?ERRLI_P28OUT	= 1
_?ERRLI_P29OUT	= 1
_?C15OUT	= 1
_?C18OUT	= 1
_?C21OUT	= 1 
_?C24OUT	= 1 
_?C27OUT	= 1

;............................

;Zalohovane oblasti pred vypnutim

B_POL_BACKUP		DD 6 DUP (0)
B_INK_BACKUP		DD 6 DUP (0)

LABEL_MEM		DB 1000	DUP (0)	    ;ZALOHOVANA	OBLAST PLC
			DB   40	DUP (0)

TAB_TECHNOL	 	TAB_TECHNOLS <(0)>
TAB_TECHNOL_DATA        DB (1700 - TYPE TAB_TECHNOLS) dup (0)
		 	DB   40	DUP (0)

_?LABEL_MEM	=  1
_?TAB_TECHNOL	=  2

;............................

;Processor number a password

PROCNUM_BSP	DD 4 DUP (0)	
PROCNUM_SEC	DD 4 DUP (0)	
BIOS_BSP	DD 0
		DD 0

Password_0	DD 2 DUP (0)
Password_1	DD 2 DUP (0)
Password_2	DD 2 DUP (0)
Password_3	DD 2 DUP (0)
Password_4	DD 2 DUP (0)
Password_5	DD 2 DUP (0)
Password_6	DD 2 DUP (0)
Password_7	DD 2 DUP (0)
Password_8	DD 2 DUP (0)
Password_9	DD 2 DUP (0)

;............................

;Cesty pro PLC moduly
ALIGN 16
PATH_PLC_MAIN	DB  48 DUP (0)		;Hlavni
PATH_PLC_FAR0	DB  48 DUP (0)		;PIS_FAR
PATH_PLC_E003	DB  48 DUP (0)		;UNITy ....
PATH_PLC_JOIN	DB  48 DUP (0)		;CELKOVY
PATH_PLC_rez	DB  48 DUP (0)		;rezerva
;............................

DCOM_REZER1	DD  28 DUP (0)		;Rezerva	


;............................

;Hodnoty potenciometru CDISTP-KLA40

EXT_POTENC	DW   8 DUP (0)
_?EXT_POTENC	= 2


;............................

;Datova oblast pro PLC obrazovky

STCH_IN_HEAD	STCH_IN_HEADS  <(0)>
STCH_IN_FIELD	DB 10000 DUP 	(0)

STCH_OUT_HEAD	STCH_OUT_HEADS  <(0)>	
STCH_OUT_FIELD	DB 10000 DUP 	 (0)

;............................

;SOUBOROVA SPRAVA PRO SEC.PROC A PRO DLL-PRIM.PROC
ifdef _KEY_FILES

aCloseHandle	CLOSEHANDLES	max_filereq_sec	DUP (<(0)>)
apCloseHandle	CLOSEHANDLES	max_filereq_bsp	DUP (<(0)>)

aCopyFile	COPYFILES	max_filereq_sec	DUP (<(0)>)
apCopyFile	COPYFILES	max_filereq_bsp	DUP (<(0)>)

aCreateDir	CREATEDIRS	max_filereq_sec	DUP (<(0)>)
apCreateDir	CREATEDIRS	max_filereq_bsp	DUP (<(0)>)

aCreatDirLst	CREATDIRLSTS	max_filereq_sec	DUP (<(0)>)
apCreatDirLst	CREATDIRLSTS	max_filereq_bsp	DUP (<(0)>)

aCreateFile	CREATEFILES	max_filereq_sec	DUP (<(0)>)
apCreateFile	CREATEFILES	max_filereq_bsp	DUP (<(0)>)

aDeleteFile	DELETEFILES	max_filereq_sec	DUP (<(0)>)
apDeleteFile	DELETEFILES	max_filereq_bsp	DUP (<(0)>)

aGetFileInfo	GETFILEINFOS	max_filereq_sec	DUP (<(0)>)
apGetFileInfo	GETFILEINFOS	max_filereq_bsp	DUP (<(0)>)

aReadFile	READFILES	max_filereq_sec	DUP (<(0)>)
apReadFile	READFILES	max_filereq_bsp	DUP (<(0)>)

aRemoveDir	REMOVEDIRS	max_filereq_sec	DUP (<(0)>)
apRemoveDir	REMOVEDIRS	max_filereq_bsp	DUP (<(0)>)

aMoveFile	MOVEFILES	max_filereq_sec	DUP (<(0)>)
apMoveFile	MOVEFILES	max_filereq_bsp	DUP (<(0)>)

aSetFileTime    SETFILETIMES	max_filereq_sec	DUP (<(0)>)
apSetFileTime   SETFILETIMES	max_filereq_bsp	DUP (<(0)>)

aWriteFile	WRITEFILES	max_filereq_sec	DUP (<(0)>)
apWriteFile	WRITEFILES	max_filereq_bsp	DUP (<(0)>)

aGetFileTime    GETFILETIMES	max_filereq_sec	DUP (<(0)>)
apGetFileTime   GETFILETIMES	max_filereq_bsp	DUP (<(0)>)

DCOM_REZER2	DD  32 DUP (0)		;Rezerva	

else
 DB 2988 DUP (0)		;! Oblast pro souborovou zpravu
endif 

;........................................

;Sdileni pro FS server

BSP_PathRoot		PATHSHARES <>
BSP_PathSyst		PATHSHARES <>
BSP_PathCmos		PATHSHARES <>
BSP_PathSysfiles	PATHSHARES <>
PLC_PathUser		PATHSHARES <>
PLC_PathBin		PATHSHARES <>
PLC_PathOutput		PATHSHARES <>
PLC_PathRez1		PATHSHARES <>
PLC_PathRez2		PATHSHARES <>
PLC_PathRez3		PATHSHARES <>
PLC_PathRez4		PATHSHARES <>
PLC_PathRez5		PATHSHARES <>

;..............

;Dulezite promenne pro rizeni vretene

REQ_SPEED_PM	DD	0	;Pozadovane otacky v tisicinach otacky za minutu
REQ_SPEED_PT	DD	0	;Pozadovane otacky v tisicinach stupne za takt
ACT_SPEED_PM	DD	0	;Aktualni otacky v tisicinach otacky za minutu
ACT_SPEED_PT	DD	0	;Aktualni otacky v tisicinach stupne za takt
ACT_SPEED2_PM	DD	0	;Otacky 2.vretene v tisicinach otacky za minutu
ACT_SPEED2_PT	DD	0	;Otacky 2.vretene v tisicinach stupne za takt
AVG_SPEED_PM	DD	0	;Prumerne otacky v tisicinach otacky za minutu
AVG_SPEED_PT	DD	0	;Prumerne otacky v tisicinach stupne za takt
AVG_SPEED2_PM	DD	0	;Prumerne otacky 2.vretene v tisicinach otacky za minutu
AVG_SPEED2_PT	DD	0	;Prumerne otacky 2.vretene v tisicinach stupne za takt
REQW_SPEED2_PM	DD	0	;Zadane otacky pro 2.vreteno (pro zobrazeni)

rez_speed	DD      0	;rezerva	


;..............

;Externi periferie

KNF_EXT_ALL	DD	0	;Konfigurace dle R231 + vse dalsi
KNF_EXT_INOUT 	DD	0	;Konfigurace dle R231		INOUT07
KNF_EXT_POTENC	DD	0	;Konfigurace dle R390 - R393  	AINP
KNF_EXT_rez1  	DD	0	;
KNF_EXT_rez2  	DD	0	;


;Hodnoty analog.kanalu AINP

EXT_ANALOG	DW 16 DUP (0)
_?EXT_ANALOG	= 2

BUF_AINP1	DW 6 DUP (0)	;Sejmute hodnoty analog. vstupu
BUF_AINP2	DW 6 DUP (0)
BUF_AINP3	DW 6 DUP (0)
BUF_AINP4	DW 6 DUP (0)

;Verze externich periferii
EXT_VER_INOUT	DB 16 dup (0)


;*** Nezavilse nastavovani vystupu 1.KANAL ***

SETH_TLOUTM	DB	0    ;1.PORT	OP0 INOUT07 (slave=2) JP1=1  log.1 
SETL_TLOUTM	DB	0    ;1.PORT	OP0 INOUT07 (slave=2) JP1=1  log.0 
SETF_TLOUTM	DB	0    ;1.PORT	OP0 INOUT07 (slave=2) JP1=1  fyzicky vystup 
SETH_TLOUTM2	DB	0    ;17.PORT	OP0 INOUT07 (slave=2) JP1=1  log.1 
SETL_TLOUTM2	DB	0    ;17.PORT	OP0 INOUT07 (slave=2) JP1=1  log.0 
SETF_TLOUTM2	DB	0    ;17.PORT	OP0 INOUT07 (slave=2) JP1=1  fyzicky vystup 


SETH_P0OUT	DB	0    ;2.PORT	OP0 INOUT07 (slave=3) JP1=2 log.1
SETH_P1OUT	DB	0    ;3.PORT	OP1
SETH_P2OUT	DB	0    ;4.PORT	OP2
		DB	0    
SETL_P0OUT	DB	0    ;2.PORT	OP0 log.0 
SETL_P1OUT	DB	0    ;3.PORT	OP1
SETL_P2OUT	DB	0    ;4.PORT	OP2
		DB	0    
		DB	0    ;2.PORT	OP0 fyzicky vystup 
		DB	0    ;3.PORT	OP1
		DB	0    ;4.PORT	OP2
		DB	0    
   
SETH_P3OUT	DB	0    ;5.PORT	OP0 INOUT07 (slave=4) JP1=3 log.1 
SETH_P4OUT	DB	0    ;6.PORT	OP1
SETH_P5OUT	DB	0    ;7.PORT	OP2
		DB	0    
SETL_P3OUT	DB	0    ;5.PORT	OP0 log.0
SETL_P4OUT	DB	0    ;6.PORT	OP1
SETL_P5OUT	DB	0    ;7.PORT	OP2
		DB	0    
		DB	0    ;5.PORT	OP0 fyzicky vystup 
		DB	0    ;6.PORT	OP1
		DB	0    ;7.PORT	OP2
		DB	0    
   
SETH_P6OUT	DB	0    ;8.PORT	OP0 INOUT07 (slave=5) JP1=4 log.1 
SETH_P7OUT	DB	0    ;9.PORT	OP1
SETH_P8OUT	DB	0    ;10.PORT	OP2
		DB	0    
SETL_P6OUT	DB	0    ;8.PORT	OP0 log.0
SETL_P7OUT	DB	0    ;9.PORT	OP1
SETL_P8OUT	DB	0    ;10.PORT	OP2
		DB	0    
		DB	0    ;8.PORT	OP0 fyzicky vystup 
		DB	0    ;9.PORT	OP1
		DB	0    ;10.PORT	OP2
		DB	0    
   
SETH_P9OUT	DB	0    ;11.PORT	OP0 INOUT07 (slave=6) JP1=5 log.1 
SETH_P10OUT	DB	0    ;12.PORT	OP1
SETH_P11OUT	DB	0    ;13.PORT	OP2
		DB	0    
SETL_P9OUT	DB	0    ;11.PORT	OP0 log.0 
SETL_P10OUT	DB	0    ;12.PORT	OP1
SETL_P11OUT	DB	0    ;13.PORT	OP2
		DB	0    
		DB	0    ;11.PORT	OP0 fyzicky vystup 
		DB	0    ;12.PORT	OP1
		DB	0    ;13.PORT	OP2
		DB	0    

SETH_P12OUT	DB	0    ;14.PORT	OP0 INOUT07 (slave=7) JP1=6 log.1 
SETH_P13OUT	DB	0    ;15.PORT	OP1
SETH_P14OUT	DB	0    ;16.PORT	OP2
		DB	0    
SETL_P12OUT	DB	0    ;14.PORT	OP0 log.0
SETL_P13OUT	DB	0    ;15.PORT	OP1
SETL_P14OUT	DB	0    ;16.PORT	OP2
		DB	0    
		DB	0    ;14.PORT	OP0 fyzicky vystup 
		DB	0    ;15.PORT	OP1
		DB	0    ;16.PORT	OP2
		DB	0    

SETH_TLOUT 	equ 	SETH_P0OUT 
SETL_TLOUT 	equ 	SETL_P0OUT 

;*** Nezavilse nastavovani vystupu 2.KANAL *** (musi primo pokracovat)

SETH_P15OUT	DB	0    ;18.PORT	OP0 INOUT07 (slave=3) JP1=2 log.1 
SETH_P16OUT	DB	0    ;19.PORT	OP1
SETH_P17OUT	DB	0    ;20.PORT	OP2
		DB	0    
SETL_P15OUT	DB	0    ;18.PORT	OP0 log.0
SETL_P16OUT	DB	0    ;19.PORT	OP1
SETL_P17OUT	DB	0    ;20.PORT	OP2
		DB	0    
		DB	0    ;18.PORT	OP0 fyzicky vystup 
		DB	0    ;19.PORT	OP1
		DB	0    ;20.PORT	OP2
		DB	0    

SETH_P18OUT	DB	0    ;21.PORT	OP0 INOUT07 (slave=4) JP1=3 log.1 
SETH_P19OUT	DB	0    ;22.PORT	OP1
SETH_P20OUT	DB	0    ;23.PORT	OP2
		DB	0    
SETL_P18OUT	DB	0    ;21.PORT	OP0 log.0
SETL_P19OUT	DB	0    ;22.PORT	OP1
SETL_P20OUT	DB	0    ;23.PORT	OP2
		DB	0    
		DB	0    ;21.PORT	OP0 fyzicky vystup 
		DB	0    ;22.PORT	OP1
		DB	0    ;23.PORT	OP2
		DB	0    

SETH_P21OUT	DB	0    ;24.PORT	OP0 INOUT07 (slave=5) JP1=4 log.1 
SETH_P22OUT	DB	0    ;25.PORT	OP1
SETH_P23OUT	DB	0    ;26.PORT	OP2
		DB	0    
SETL_P21OUT	DB	0    ;24.PORT	OP0 log.0 
SETL_P22OUT	DB	0    ;25.PORT	OP1
SETL_P23OUT	DB	0    ;26.PORT	OP2
		DB	0    
		DB	0    ;24.PORT	OP0 fyzicky vystup 
		DB	0    ;25.PORT	OP1
		DB	0    ;26.PORT	OP2
		DB	0    

SETH_P24OUT	DB	0    ;27.PORT	OP0 INOUT07 (slave=6) JP1=5 log.1 
SETH_P25OUT	DB	0    ;28.PORT	OP1
SETH_P26OUT	DB	0    ;29.PORT	OP2
		DB	0    
SETL_P24OUT	DB	0    ;27.PORT	OP0 log.0 
SETL_P25OUT	DB	0    ;28.PORT	OP1
SETL_P26OUT	DB	0    ;29.PORT	OP2
		DB	0    
		DB	0    ;27.PORT	OP0 fyzicky vystup 
		DB	0    ;28.PORT	OP1
		DB	0    ;29.PORT	OP2
		DB	0    

SETH_P27OUT	DB	0    ;30.PORT	OP0 INOUT07 (slave=7) JP1=6 log.1 
SETH_P28OUT	DB	0    ;31.PORT	OP1
SETH_P29OUT	DB	0    ;32.PORT	OP2
		DB	0    
SETL_P27OUT	DB	0    ;30.PORT	OP0 log.0 
SETL_P28OUT	DB	0    ;31.PORT	OP1
SETL_P29OUT	DB	0    ;32.PORT	OP2
		DB	0    
		DB	0    ;30.PORT	OP0 fyzicky vystup 
		DB	0    ;31.PORT	OP1
		DB	0    ;32.PORT	OP2
		DB	0    


;*** Nezavilse nastavovani vstupu 1.KANAL ***

SETL_PANEL_STROJE   DB  8 DUP	(0)       ;MATICE  (slave=2) JP1=1  log.0 
SETL_PANEL_STROJE2  DB  8 DUP	(0)       ;MATICE  (slave=2) JP1=1  log.0

SETH_PANEL_STROJE   DB  8 DUP	(0)       ;MATICE  (slave=2) JP1=1  log.1
SETH_PANEL_STROJE2  DB  8 DUP	(0)       ;MATICE  (slave=2) JP1=1  log.1  

SETF_PANEL_STROJE   DB  8 DUP	(0)       ;MATICE  (slave=2) JP1=1  fyzicke vstupy
SETF_PANEL_STROJE2  DB  8 DUP	(0)       ;MATICE  (slave=2) JP1=1  fyzicke vstupy  


SETH_P1IN    	    DB	0    ;1.PORT   IP0 INOUT07 (slave=3) JP1=2 log.1 
SETH_P2IN    	    DB	0    ;2.PORT   IP1
SETH_P3IN    	    DB	0    ;3.PORT   IP2
SETH_P4IN    	    DB	0    ;4.PORT   IP3
SETL_P1IN    	    DB	0    ;1.PORT   IP0	log.0
SETL_P2IN    	    DB	0    ;2.PORT   IP1	
SETL_P3IN    	    DB	0    ;3.PORT   IP2	
SETL_P4IN    	    DB	0    ;4.PORT   IP3	
	    	    DB	0    ;1.PORT   IP0	fyzicke vstupy
	    	    DB	0    ;2.PORT   IP1	
	    	    DB	0    ;3.PORT   IP2	
	    	    DB	0    ;4.PORT   IP3	

SETH_P5IN	    DB	0    ;5.PORT   IP0 INOUT07 (slave=4) JP1=3 log.1  
SETH_P6IN	    DB	0    ;6.PORT   IP1
SETH_P7IN	    DB	0    ;7.PORT   IP2
SETH_P8IN	    DB	0    ;8.PORT   IP3
SETL_P5IN    	    DB	0    ;5.PORT   IP0	log.0
SETL_P6IN    	    DB	0    ;6.PORT   IP1	
SETL_P7IN    	    DB	0    ;7.PORT   IP2	
SETL_P8IN    	    DB	0    ;8.PORT   IP3	
	    	    DB	0    ;5.PORT   IP0	fyzicke vstupy
	    	    DB	0    ;6.PORT   IP1	
	    	    DB	0    ;7.PORT   IP2	
	    	    DB	0    ;8.PORT   IP3	

SETH_P9IN	    DB	0    ;9.PORT   IP0 INOUT07 (slave=5) JP1=4 log.1  
SETH_P10IN	    DB	0    ;10.PORT  IP1
SETH_P11IN	    DB	0    ;11.PORT  IP2
SETH_P12IN	    DB	0    ;12.PORT  IP3
SETL_P9IN	    DB	0    ;11.PORT  IP0	log.0
SETL_P10IN          DB	0    ;12.PORT  IP1	
SETL_P11IN          DB	0    ;13.PORT  IP2	
SETL_P12IN          DB	0    ;14.PORT  IP3	
	    	    DB	0    ;11.PORT  IP0	fyzicke vstupy
	    	    DB	0    ;12.PORT  IP1	
	    	    DB	0    ;13.PORT  IP2	
	    	    DB	0    ;14.PORT  IP3	

SETH_P13IN	    DB	0    ;13.PORT  IP0 INOUT07 (slave=6) JP1=5 log.1   
SETH_P14IN	    DB	0    ;14.PORT  IP1
SETH_P15IN	    DB	0    ;15.PORT  IP2
SETH_P16IN	    DB	0    ;16.PORT  IP3
SETL_P13IN    	    DB	0    ;13.PORT  IP0	log.0
SETL_P14IN    	    DB	0    ;14.PORT  IP1	
SETL_P15IN    	    DB	0    ;15.PORT  IP2	
SETL_P16IN    	    DB	0    ;16.PORT  IP3	
	    	    DB	0    ;13.PORT  IP0	fyzicke vstupy
	    	    DB	0    ;14.PORT  IP1	
	    	    DB	0    ;15.PORT  IP2	
	    	    DB	0    ;16.PORT  IP3	

SETH_P17IN	    DB	0    ;17.PORT  IP0 INOUT07 (slave=7) JP1=6 log.1 
SETH_P18IN	    DB	0    ;18.PORT  IP1
SETH_P19IN	    DB	0    ;19.PORT  IP2
SETH_P20IN	    DB	0    ;20.PORT  IP3
SETL_P17IN    	    DB	0    ;17.PORT  IP0	log.0
SETL_P18IN    	    DB	0    ;18.PORT  IP1	
SETL_P19IN    	    DB	0    ;19.PORT  IP2	
SETL_P20IN    	    DB	0    ;20.PORT  IP3	
	    	    DB	0    ;17.PORT  IP0	fyzicke vstupy
	    	    DB	0    ;18.PORT  IP1	
	    	    DB	0    ;19.PORT  IP2	
	    	    DB	0    ;20.PORT  IP3	


;*** Nezavilse nastavovani vstupu 2.KANAL *** (musi primo pokracovat)


SETH_P21IN	    DB	0    ;21.PORT  IP0 INOUT07 (slave=3) JP1=2  log.1 
SETH_P22IN	    DB	0    ;22.PORT  IP1
SETH_P23IN	    DB	0    ;23.PORT  IP2
SETH_P24IN	    DB	0    ;24.PORT  IP3
SETL_P21IN    	    DB	0    ;21.PORT  IP0	log.0
SETL_P22IN    	    DB	0    ;22.PORT  IP1	
SETL_P23IN    	    DB	0    ;23.PORT  IP2	
SETL_P24IN    	    DB	0    ;24.PORT  IP3	
	    	    DB	0    ;21.PORT  IP0	fyzicke vstupy
	    	    DB	0    ;22.PORT  IP1	
	    	    DB	0    ;23.PORT  IP2	
	    	    DB	0    ;24.PORT  IP3	

SETH_P25IN	    DB	0    ;25.PORT  IP0 INOUT07 (slave=4) JP1=3 log.1
SETH_P26IN	    DB	0    ;26.PORT  IP1
SETH_P27IN	    DB	0    ;27.PORT  IP2
SETH_P28IN	    DB	0    ;28.PORT  IP3
SETL_P25IN    	    DB	0    ;25.PORT  IP0	log.0
SETL_P26IN    	    DB	0    ;26.PORT  IP1	
SETL_P27IN    	    DB	0    ;27.PORT  IP2	
SETL_P28IN    	    DB	0    ;28.PORT  IP3	
	    	    DB	0    ;25.PORT  IP0	fyzicke vstupy
	    	    DB	0    ;26.PORT  IP1	
	    	    DB	0    ;27.PORT  IP2	
	    	    DB	0    ;28.PORT  IP3	

SETH_P29IN	    DB	0    ;29.PORT  IP0 INOUT07 (slave=5) JP1=4 log.1  
SETH_P30IN	    DB	0    ;30.PORT  IP1
SETH_P31IN	    DB	0    ;31.PORT  IP2
SETH_P32IN	    DB	0    ;32.PORT  IP3
SETL_P29IN    	    DB	0    ;29.PORT  IP0	log.0
SETL_P30IN    	    DB	0    ;30.PORT  IP1	
SETL_P31IN    	    DB	0    ;31.PORT  IP2	
SETL_P32IN    	    DB	0    ;32.PORT  IP3	
	    	    DB	0    ;29.PORT  IP0	fyzicke vstupy
	    	    DB	0    ;30.PORT  IP1	
	    	    DB	0    ;31.PORT  IP2	
	    	    DB	0    ;32.PORT  IP3	

SETH_P33IN	    DB	0    ;33.PORT  IP0 INOUT07 (slave=6) JP1=5 log.1  
SETH_P34IN	    DB	0    ;34.PORT  IP1
SETH_P35IN	    DB	0    ;35.PORT  IP2
SETH_P36IN	    DB	0    ;36.PORT  IP3
SETL_P33IN    	    DB	0    ;33.PORT  IP0	log.0
SETL_P34IN    	    DB	0    ;34.PORT  IP1	
SETL_P35IN    	    DB	0    ;35.PORT  IP2	
SETL_P36IN    	    DB	0    ;36.PORT  IP3	
	    	    DB	0    ;33.PORT  IP0	fyzicke vstupy
	    	    DB	0    ;34.PORT  IP1	
	    	    DB	0    ;35.PORT  IP2	
	    	    DB	0    ;36.PORT  IP3	

SETH_P37IN	    DB	0    ;37.PORT  IP0 INOUT07 (slave=7) JP1=6 log.1  
SETH_P38IN	    DB	0    ;38.PORT  IP1
SETH_P39IN	    DB	0    ;39.PORT  IP2
SETH_P40IN	    DB	0    ;40.PORT  IP3
SETL_P37IN    	    DB	0    ;37.PORT  IP0	log.0
SETL_P38IN    	    DB	0    ;38.PORT  IP1	
SETL_P39IN    	    DB	0    ;39.PORT  IP2	
SETL_P40IN    	    DB	0    ;40.PORT  IP3	
	    	    DB	0    ;37.PORT  IP0	fyzicke vstupy
	    	    DB	0    ;38.PORT  IP1	
	    	    DB	0    ;39.PORT  IP2	
	    	    DB	0    ;40.PORT  IP3	

;*** Systemovy cas a datum ***

SYST_DATE_KEY	    DB  'TM'
SYST_DATE_BUSY	    DB  0
SYST_DATE_REZ	    DB  0	
SYST_DATE_BUFF	    DD  8 DUP    (0)		;pole 8 DWORD

SYST_TIME_INFO	    TIME_INFOS  <(0)>		;systemovy cas
SYST_DATE_INFO	    DATE_INFOS  <(0)>		;systemovy datum
SYST_DATE_REZ2	    DD  6 DUP    (0)	


;*** Tabulka vleceni pro rizeni z PLC ***

TRAIL_X		TRAILS	<(0)>
TRAIL_Y		TRAILS	<(0)>
TRAIL_Z		TRAILS	<(0)>
TRAIL_4		TRAILS	<(0)>
TRAIL_5		TRAILS	<(0)>
TRAIL_6		TRAILS	<(0)>
TRAIL_7		TRAILS	<(0)>
TRAIL_8		TRAILS	<(0)>
TRAIL_9		TRAILS	<(0)>
TRAIL_10	TRAILS	<(0)>
TRAIL_11	TRAILS	<(0)>
TRAIL_12	TRAILS	<(0)>
TRAIL_13	TRAILS	<(0)>
TRAIL_14	TRAILS	<(0)>
TRAIL_15	TRAILS	<(0)>
TRAIL_16	TRAILS	<(0)>


;*** Bitove pole pro prirazeni tlacitek pomoci maker (2) 4000h - 5F00h ***
PTL4IN		DB	0
PTL5IN		DB	0
PTL6IN		DB	0
PTL7IN		DB	0
PTLxxxIN	DB 12 DUP (0)

_?PTL4IN	=	1
_?PTL5IN	=	1
_?PTL6IN	=	1
_?PTL7IN	=	1


;*** Oblast pro rizeni transformace souradnic ***
ifdef _KEY_TRANS
;** 1.rovinna transformace **
TRANS_FLAT1_STATUS	transs	 <(0)>	;stav
TRANS_FLAT1_COMMAND	transs	 <(0)>	;povely pro transformaci
TRANS_FLAT1_AXIS	DB	   0	;definice transformovanych os
TRANS_FLAT1_MODIF	DB	   0	;modifikace
TRANS_FLAT1_A		matrix13 <(0)>	;Posun realni a fiktivni soustavy (TBYTE, prvky a1,a2)
TRANS_FLAT1_MATRIX	matrix22 <(0)>	;Matice transformace pro razeni (TR) (TBYTE)
TRANS_FLAT1_ADJMATRIX	matrix22 <(0)>	;Adjungovana matice transformace pro vyrazeni (\TR)
TRANS_FLAT1_PARAM	transp   <(0)>  ;Parametry zadani

;** 2.rovinna transformace **
TRANS_FLAT2_STATUS	transs	 <(0)>	;stav
TRANS_FLAT2_COMMAND	transs	 <(0)>	;povely pro transformaci
TRANS_FLAT2_AXIS	DB	   0	;definice transformovanych os
TRANS_FLAT2_MODIF	DB	   0	;modifikace
TRANS_FLAT2_A		matrix13 <(0)>	;Posun realni a fiktivni soustavy (TBYTE, prvky a1,a2)
TRANS_FLAT2_MATRIX	matrix22 <(0)>	;Matice transformace pro razeni (TR) (TBYTE)
TRANS_FLAT2_ADJMATRIX	matrix22 <(0)>	;Adjungovana matice transformace pro vyrazeni (\TR)
TRANS_FLAT2_PARAM	transp   <(0)>  ;Parametry zadani


;** 1.prostorova transformace **
TRANS_SPACE1_STATUS	transs	 <(0)>	;stav
TRANS_SPACE1_COMMAND	transs	 <(0)>	;povely pro transformaci
TRANS_SPACE1_AXIS	DB	   0	;definice transformovanych os
TRANS_SPACE1_MODIF	DB	   0	;modifikace (rezerva)
TRANS_SPACE1_A		matrix13 <(0)>	;Posun realni a fiktivni soustavy (TBYTE, prvky a1,a2)
TRANS_SPACE1_MATRIX	matrix33 <(0)>	;Matice transformace pro razeni (TR) (TBYTE)
TRANS_SPACE1_ADJMATRIX	matrix33 <(0)>	;Adjungovana matice transformace pro vyrazeni (\TR)
TRANS_SPACE1_PARAM	transp   <(0)>  ;Parametry zadani

TRANS_ALL_ODM		DQ 6  DUP (0)	;Skutecne odmerovani po vsech transformacich \TR(fict_odm)

trans_rezer		DQ 10 DUP (0)   ;rezerva

_?TRANS_FLAT1_MODIF = 1
_?TRANS_FLAT2_MODIF = 1


else
  TRANS_FLAT1_STATUS	DB 642 DUP (0)  ;! delka oblasti transformace
endif

trans_rezer_end		DW	   0    ;konec


;** Rozsireni rozhrani o nektere dalsi funkce **
PB_ENH1			pb_enh1r <(0)>	;bitove pole PB_ENH
PB_ENH2			pb_enh2r <(0)>	;bitove pole PB_ENH
			DB 32 DUP (0)
			
BZH_ENH1		bzh_enh1r <(0)>	;bitove pole BZH_ENH
BZH_ENH2		DB	0
			DB 32 DUP (0)
	
SPEED_OVR_EXT		DB 2 DUP  (0)	;externi rizeni proc.S
DATA_PLCTOC1		DW 4 DUP  (0)	;data z PLC tocitek
DATA_PLCTOC2		DW 4 DUP  (0)

DISPTOC1	        DB 8 DUP (0)  ;pole pro 1.tocitko s displejem
DISPTOC2	        DB 8 DUP (0)  ;pole pro 2.tocitko s displejem

			DW 16 DUP (0)

;~~~
_?PB_ENH1	=	1
_?BZH_ENH1	=	1
_?SPEED_OVR_EXT =	1
_?DISPTOC1	=	1
_?DISPTOC2	=	1


;** Osciloskop **

ifdef _KEY_OSCIL
;Nastaveni kanalu osciloskopu
CHANNEL_1		CHANNELS <(0)>
CHANNEL_2		CHANNELS <(0)>
CHANNEL_3		CHANNELS <(0)>
CHANNEL_4		CHANNELS <(0)>
CHANNEL_5		CHANNELS <(0)>
CHANNEL_6		CHANNELS <(0)>

;Rizeni osciloskopu
CHANNEL_TRIGGER_REQ	  DB	0	;Trigger nastaven - pozadovan (0...neni)
CHANNEL_VIEW		  DB	0	;Povel z panelu pro vykresleni z bufferu 
CHANNEL_SCREEN		  DB	0	;Povel z kazety pro vykresleni 
CHANNEL_SCALE		  DB	0	;Mirka (1,2,..6)
CHANNEL_POSTTRIGGER	  DD	0	;Zaznam po prichodu triggeru [ms] 	(+newosc)
CHANNEL_RUN		  DB	0	;Cekani na dlasi triger
CHANNEL_TRIGGER_MANUAL	  DB	0	;Povel pro manualni spousteni 
CHANNEL_TRIGGER_AUTO	  DB	0	;Trigger nastaven 			(+newosc)
CHANNEL_TRIGGER_RELATION  DB	0	;Relace na spousteni triggeru 
					;1...bit=1     2...bit=0
					;10..GE(>=)    11..LT(<)      12..EQ(=)
CHANNEL_TRIGGER_STANDARD  DW	0	;Standardni vzory adres triggeru
CHANNEL_TRIGGER_WEIGHT	  DB	0	;vaha bitu (1,2,..80h), nebo 0=WORD,09h=BYTE,099h=DWORD
CHANNEL_TRIGGER_OFFS	  DD	0	;Adresa pro podminku triggeru
CHANNEL_TRIGGER_DATA1	  DD	0	;Data pro podminku triggeru

CHANNEL_TRIGGER_CONDITION DB	0	;Podminka pro 2. trigger (0=2.trigger neni, 1=AND, 2=OR)
CHANNEL_TRIGGER_RELATION2 DB	0	;Relace na spousteni 2. triggeru
CHANNEL_TRIGGER_STANDARD2 DW	0	;Standardni vzory adres 2. triggeru
CHANNEL_TRIGGER_WEIGHT2	  DB	0	;vaha bitu (1,2,..80h), nebo 0=WORD,09h=BYTE,099h=DWORD
CHANNEL_TRIGGER_OFFS2	  DD	0	;Adresa pro podminku 2. triggeru
CHANNEL_TRIGGER_DATA2	  DD	0	;Data pro podminku 2. triggeru

;Pro vicekanalovy osciloskop
CHANNEL2_RUN		  DB	0	;Cekani na dlasi triger
CHANNEL2_VIEW		  DB	0	;Povel z panelu pro vykresleni z bufferu (nebo prichod triggeru)
CHANNEL2_TRIGGER_MANUAL	  DB	0	;Povel pro manualni spousteni
CHANNEL2_BUSY		  DB	0	;Povel pro prevzeti
CHANNEL2_FIRSTSAMPLE	  DD	0	;ndex prvniho vzorku (nejstarsi platny) - prebirana
CHANNEL2_LASTSAMPLE	  DD	0	;Index posledniho vzorku (nejmladsi vzorek) - prebirana
CHANNEL2_MAXSAMPLE	  DD    0       ;Maximalni pocet zaznamu
CHANNEL2_LASTSAMPLE_B	  DD    0	;pracovni
CHANNEL2_FIRSTSAMPLE_B    DD    0

CHANNEL_REZERV		DW 20 DUP (0)

else
  DB 244 DUP (0)		;! oblast osciloskopu
endif


;*** Nektere dulezite pointry a promenne ***
POI_E13_EIP	    point_d <0,0>
F_SKUPR_EX	    DD	0
F_SKUPR_EX_BUSY	    DB	0
DYNAM_SET	    DB	0
POI_RAR0	    DD	0
POI_BWRK	    DD	0
AVG_SPEED2_EX	    DD  0
AVG_SPEED2_EX_BUSY  DB  0
BUKON60_R2_EX	    DB  0	
REQW_SPEED2_EX	    DD	0
REQW_SPEED2_EX_BUSY DB  0
POI_EVENT_EX	    DD  0	;EVENT
NUM_EVENT_EX        DD  0
B_EVENT_BUSY	    DB  0
FL_PLC_COM_PORT	    DW  0
rez_com_port	    DW  0

INTNUM_SU5          DB  0			;pro SU5 s interruptem - jen priznak
REZERV_SU5          DB  0			;rezerva		
INTNUM_AXIS         DW  INTNUM_AXIS_def
IO_APIC_RTL_SU5     DD  IO_APIC_RTL_SU5_def
IO_APIC_RTH_SU5     DD  IO_APIC_RTH_SU5_def

AVG_SPEED_EX	    DD  0
SPI_MAIN_XCHG	    DB  0			;priznak prohozeni
SPI_MAIN_DEF	    DB  0			;priznak definice pro hlavni vreteno		
SPI_MAIN_SET	    DB  0			;priznak nastaveni hlavniho vretene	
__DEBUG_STATE	    DB  0FFh
AVG_SPEED_EX_BUSY   DB  0

COUNT_EVENT_CRITIC  DD	0			;Citac kritickych udalosti	

		    DB 3 DUP (0)
		    DD 15 DUP (0)


;*** Hodnoty analog.kanalu AINP pro PT100
EXT_PT100	    DW  8 DUP (0)
EXT_T_PT100         DD  8 DUP (0)


;*** Tepelna kompenzace
THERMKOR_X	  	DW 6 DUP (0)	;ridici byte pro tepelnou korekci (High=modifikace)
THERMKOR_X_MIN	  	DD 6 DUP (0)	;min hodnota
THERMKOR_X_BEGIN	DD 6 DUP (0)	;pocatek tepelne komenzace 
THERMKOR_X_ALFA		DW 6 DUP (0)	;soucinitel
THERMKOR_X_THERM	DW 6 DUP (0)	;pointer na teplomer 0,4,8,..
			DD 8 DUP (0)	;rezerva

;*** Dotykova sonda ***
B_TPS_X			DD 6 DUP (0)	;fiktivni poloha dotyku (1.karta)
B_TPS_TRANS_X		DD 6 DUP (0)	;realna poloha dotyku   (1.karta)
FL_TPS_PAR		DW 0		;cislo parametru
FL_TPS_TOUCH		DB 0		;fiktivni data sejmuta pro 1.kartu (bity vsech os)
FL_TPS_TOUCH_TRANS	DB 0		;realna data sejmuta pro 1.kartu
			DD 8 DUP (0)	;rezerva


;*** Udalosti EVENT z panelu max 10 najednou (cas nevyplnen, EVENTS_HOUR je BUSY)
PANEL_EVENT		EVENTS	10 DUP (<(0)>)
REZ_EVENTS		DD  8 DUP (0)


;*** PRO SLM - SU05 ***

SlmComReq               DW MAX_POC_OS_ODM DUP (0)
                            ;       0 - No action
                            ;       1 - Initialise axis
                            ;       2 - Enable/Disable drive, read flags, select PID param.
                            ;       3 - Clear SLM index flag
                            ;       4 - Set PID parameters
SlmComErr               DW MAX_POC_OS_ODM DUP (0)
                            ;       0 - no errors
                            ;       1 - this axis cannot be SLM
                            ;       2 - SLM on SU5 not active
                            ;       3 - Drive not connected
                            ;       4 - Bad SLM Identification
                            ;       5 - Reset command not succesfull
                            ;       6 - Error during EEPROM parameter read
                            ;       7 - Wrong encoder checksum
                            ;       8 - Wrong motor checksum
                            ;       9 - Cannot write parameters
                            ;       10 - Unknown command
                            ;       11 - Enable/Disable/Zero cmd - no Ack
                            ;       12 - Wrong Index Offset read
SlmIndOffs              DW MAX_POC_OS_ODM DUP (0)
                            ;       Index pulse offset in 1/65536 rev.
SlmFlagAct              DW MAX_POC_OS_ODM DUP (0)
                            ;       Nonzero => index pulse offset valid.
SlmRetAddr              DW MAX_POC_OS_ODM DUP (0)
                            ;       Return address - SLM internal var.
SlmSubRetAddr           DW MAX_POC_OS_ODM DUP (0)
                            ;       Subroutine ret. address - SLM internal var.
SlmDataAddr             DW MAX_POC_OS_ODM DUP (0)
                            ;       Structure data offset - SLM internal var.

SlmAxisData0    SlmAxisData MAX_POC_OS_ODM DUP (<>)

SLM_AX_EN_ST		DB 2 DUP (0)	;stav uvolnovani		

SU_SLM_DET0 		DB (MAX_POC_OS_ODM+3)/4 DUP (?)	;SLM deska zjistena = 0ffh.
SU_SLM_ACT0 		DB (MAX_POC_OS_ODM+3)/4 DUP (?)	;SLM deska zapnuta  = 0ffh.
SU_SLM_CTRL0 		DB (MAX_POC_OS_ODM+3)/4 DUP (?)	;Vstup z ridiciho portu.

SLM_DRIVE_STATR RECORD ?SLM_BRAKE_I2T_TRIP:1,?SLM_BRAKE_I2T_WARN:1,?SLM_DRV_FAN_FAIL:1,?SLM_DRV_TEST:1,?SLM_DRV_TORQUE:1,?SLM_DRV_TEMP:1,?SLM_AX_RDY:1,?SLM_AX_ENBLD:1
SLM_DRIVE_STAT2R RECORD ?__SLM_SREZ7:1,?__SLM_SREZ6:1,?SLM_MOT_I2T_WARN:1,?SLM_ENCODER_WARN:1,?__SLM_SREZ3:1,?__SLM_SREZ2:1,?SLM_SETS_PID1:1,?SLM_SETS_PID0:1
SLM_DRIVE_CMDR	 RECORD ?__SLM_REZ7:1,?__SLM_REZ6:1,?__SLM_REZ5:1,?__SLM_REZ4:1,?__SLM_REZ3:1,?__SLM_REZ2:1,?__SLM_REZ1:1,?SLM_AX_EN:1
SLM_DRIVE_CMDR2R RECORD ?__SLM_CREZ7:1,?__SLM_CREZ6:1,?__SLM_CREZ5:1,?__SLM_CREZ4:1,?__SLM_CREZ3:1,?__SLM_CREZ2:1,?SLM_SETC_PID1:1,?SLM_SETC_PID0:1

SLM_DRIVE_STAT		DW MAX_POC_OS_ODM DUP (0)
SLM_DRIVE_CMD		DW MAX_POC_OS_ODM DUP (0)
SLM_DRIVE_FAULT		DW MAX_POC_OS_ODM DUP (0)

SLM_BZH13_CHANNEL	DW	0		;kanal SLM pro BZH13

SLM_REF_SW_POS		DW MAX_POC_OS_ODM DUP (0)

SLM_IN_CRC_ERR		DB MAX_POC_OS_ODM DUP (0) 

REZ_SlmAxis		DW  12 DUP (0)



;*** Pro serial UPS ****

UPS_CMD		UPS_CMDR    <(0)>	;Prikazy pro UPS
UPS_STAT	UPS_STATR   <(0)>	;Stav UPS
UPS_FAULT	UPS_FAULTR  <(0)>	;Chyby UPS
UPS_SYS		UPS_SYSR    <(0)>	;Stav UPS - system

_?UPS_CMD   = 1
_?UPS_STAT  = 1
_?UPS_FAULT = 1
_?UPS_SYS   = 1

UPS_REZ		DW 10 DUP (0)



;*** Pro 16 servosmycek ****
					;Modifikace erroru BZH13 pro 16S
ERR_CHECK_16S		DB	0	;cislo osy 7-16 (hex) pro chybu kontr.citace (BZH13=1) 
ERR_DIFCIT_16S		DB	0	;cislo osy 7-16 (hex) pro limit dif.citace (BZH13=2)
ERR_REZER_16S		DB 8 DUP (0)

POI_DIFCIT_X		DD	0	;fyzicka adresa dif.citacu
POI_SERV_ACTIVE		DD	0	;fyzicka adresa aktivace
POI_SERV_LINK_XS	DD	0	;fyz.adresa pro pole prirazeni Xy-Sx
POI_B_DRT_EX		DD	0	;fyz.adresa pro B_DRT (mikrony)
POI_B_POL_EX		DD	0	;fyz.adresa pro B_POL
POI_B_INK_EX		DD	0	;fyz.adresa pro B_INK
POI_SU_UOUT0		DD	0	;fyz.adresa pro SU_UOUT0
POI_SU_IRC0		DD	0	;fyz.adresa pro SU_IRC0
POI_SU_STAT0		DD	0	;fyz.adresa pro SU_STAT0
POI_SU_CHECK_NI_ABS	DD	0	;fyz.adresa pro SU_CHECK_NI_ABS
POI_SU_CHECK_NI_INDIK	DD	0	;fyz.adresa pro POI_SU_CHECK_NI_INDIK

POI_SU_REZER		DD  10 DUP (0)


;*** Konfigurace pro NET karty a CPU

HEAD_NET		BOARDS_NET 	<>
BDVER_NET		CONFS_NET	6  DUP	 (<?>)
CPU_VERSION		DD	0
CPU_P4HT		DB	0
			DB 	3 DUP (0)
REZERV_NET		DD	9 DUP (0)


;*** Diagnostika CAN-BUS 2. kanal CAN1 ****
ERR_CANBUS_2		DW	0	;Poderror pro CAN bus pro rizeni os (BZH13=3)
_COUNT_ERR_OVERRUN2     DD      0	;citac chyb prijmu s prepsanim
_COUNT_ERR_XMTFUL2      DD      0	;citac chyb plneho bufferu pro vyslani v controleru
_COUNT_ERR_WAITINT	DD	0	;citac chyb - za 1 ms se vse neodvysilalo = vynechani taktu

CAN_DRIVE_STATR  RECORD ?CAN_AX_WARN:1,?CAN_AX_BRKD:1,?CAN_AX_QSTOP:1,?CAN_AX_VOLTAGE:1,?CAN_AX_FAULT:1,?CAN_AX_ENBLD:1,?CAN_AX_ON:1,?CAN_AX_READY:1
CAN_DRIVE_MSTATR RECORD ?CAN_WRN_MOTION:1,?CAN_WRN_LIMIT2:1,?CAN_WRN_LIMIT1:1,?CAN_WRN_POWER:1,?CAN_WRN_RESP:1,?CAN_WRN_FOLLOW:1,?CAN_WRN_BALLAST:1,?CAN_WRN_I2T:1
CAN_DRIVE_MSTA2R RECORD ?CAN_WRN_RES:1,?CAN_WRN_VCT:1,?CAN_WRN_PHASE:1,?CAN_WRN_BOARD:1,?CAN_WRN_DEF:1,?CAN_WRN_NSTOP:1,?CAN_WRN_PSTOP:1,?CAN_WRN_MOTREF:1
CAN_DRIVE_CMDR	 RECORD ?__CAN_REZ7:1,?__CAN_REZ6:1,?__CAN_REZ5:1,?__CAN_REZ4:1,?__CAN_REZ3:1,?CAN_AX_FLT:1,?CAN_AX_BRK:1,?CAN_AX_EN:1

;Pro Control Techniques Unidrive
CAN_DRIVE_CMDUR	 RECORD ?CAN_UAX_APP1:1,?CAN_UAX_SET1:1,?CAN_UAX_SET0:1,?CAN_UAX_TRIP:1,?CAN_UAX_SEQ2:1,?CAN_UAX_SEQ1:1,?CAN_UAX_SEQ0:1,?CAN_UAX_EN:1
CAN_DRIVE_MCMDUR RECORD ?CAN_UAX_M6:1,?CAN_UAX_M5:1,?CAN_UAX_APP3:1,?CAN_UAX_M3:1,?CAN_UAX_M2:1,?CAN_UAX_M1:1,?CAN_UAX_M0:1,?CAN_UAX_APP2:1
CAN_DRIVE_STATUR RECORD ?CAN_UAX_LOAD:1,?CAN_UAX_ABOVE:1,?CAN_UAX_AT:1,?CAN_UAX_BELOW:1,?CAN_UAX_RUNBEL:1,?CAN_UAX_ZERO:1,?CAN_UAX_RUN:1,?CAN_UAX_HEALTY:1	

CAN_DRIVE_STAT		DW MAX_POC_OS_ODM DUP (0)
CAN_DRIVE_MSTAT		DW MAX_POC_OS_ODM DUP (0)
CAN_DRIVE_CMD		DW MAX_POC_OS_ODM DUP (0)

CAN_AX_BUSY		DB 00h		;Pro indikaci prijmu paketu pro PLC

SIMULTAN_REFER		DW 0		;pro soucasny najezd do reference (vleceni)
			DW 0

;Pro vysilani z PLC
CAN_AX_SEND_PACKET	TCANMSGS	<00h,0,0, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h>
CAN_AX_RECV_PACKET	TCANMSGS	<00h,0,0, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h>


;*** Diagnostika CAN-BUS 1. kanal CAN2 ****

ERR_CANBUS_1		DW	0	;Poderror pro CAN bus pro PLC - CAN2 (BZH13=3)
			DW	0
_COUNT_ERR_OVERRUN      DD      0	;citac chyb prijmu s prepsanim
_COUNT_ERR_XMTFUL       DD      0	;citac chyb plneho bufferu pro vyslani v controleru




;*** Pozadavek na data z panelu ***
VAL_QYDATA		DD 16 DUP (0)	;Hodnota pro PLC - cte PLC
REQ_QYDATA		DW 16 DUP (0)	;Pozadavek dat z PLC - vyplnuje PLC
__ACP_QYDATA		DW 16 DUP (0)	;Pozadavek z kazety (neobsluhuje PLC)
__REC_QYDATA		DD 16 DUP (0)	;Hodnota  (neobsluhuje PLC)
_?REQ_QYDATA = 2


;*** Odmerovani servosmycek ***
ServoPosition		DD 16 DUP (0)	;prime odmerovani servosmycek - indikace
ServoReserv		DD 16 DUP (0)


;*** Skanovani (SCAN) hodnot ***
SCAN_SAVE		DB 0		;Prikazy pro SCAN_SAVE (record SCAN_SAVER)
SCAN_RESTORE		DB 0		;Prikazy pro SCAN_RESTORE (record SCAN_RESTORER)

SCAN_SAVE_DATA		DD 3 DUP (0)	;Data pro uchovu
SCAN_RESTORE_DATA	DD 3 DUP (0)	;Data obnovena

SCAN_ACT_COUNT		DD 0		;Aktualni citac zaznamenavani
SCAN_ACT_COUNT_BLK	DD 0		;Aktualni citac zaznamenanych bloku
SCAN_ACT_DIST		DD 0		;Aktualni distance pro zaznam (1/8 um)
SCAN_REST_ERR		DD 0		;Citac chyb pro vybirani dat

SCAN_CNF_DIST		DD 0		;Konfigurace - distance pro zaznamenavani v 1/8 um
SCAN_CNF_MAX		DD 0		;Konfigurace - maximalni pocet zaznamu

;Pro obrabeni PTV
SCAN_KOREK		DD 0		;Delkova korekce nastroje  (1/8 um)
SCAN_TRISKA		DD 0		;Zaber 1 trisky  (1/8 um)
SCAN_COUNT_TRISKA	DD 0		;Citac trisek (1,2,3,..)

SCAN_REZER		DD 8 DUP (0)	;Specielni komunikace PTV
SCAN_REZER2		DD 8 DUP (0)


;*** Konstantni rezna rychlost AKRR ***
AKRR_CNTR		DB 0		;Ovladani AKRR (record AKRR_CNTRR)
AKRR_CNTR2		DB 0

AKRR_ACT_V		DD 0		;Aktualni konstantni rezna rychlost [mm/min]
AKRR_ACT_SMAX		DD 0		;Aktualni maximalni otacky [1/1000 ot/min]
AKRR_ACT_DIST		DD 0		;Aktualni korekce polomeru [1/8 um]
AKRR_ACT_VCORR		DD 0		;Aktualni korekce rezne rychlosti [mm/min]
AKRR_ACT_R		DD 0		;Aktualni polomer [1/8 um]
AKRR_ACT_P		DD 0		;Aktualni max.otacky dle prevod.rady [1/1000 ot/min]
AKRR_ACT_U		DD 0		;Aktualni rozsah napeti dle prevod.rady [0-7FFFh]
AKRR_ACT_S		DD 0		;Aktualni vypoctene otacky [1/1000 ot/min]
AKRR_ACT_OUT		DD 0		;Aktualni vypoctene napeti [0-7FFFh]

AKRR_V			DD 0		;Konstantni rezna rychlost z PLC [mm/min]
AKRR_SMAX		DD 0		;Maximalni otacky z PLC [1/1000 ot/min]
AKRR_DIST		DD 0		;Korekce polomeru z PLC [1/8 um]
AKRR_VCORR		DD 0		;Korekce rezne rychlosti z PLC [mm/min]

AKRR_REZER		DD 8 DUP (0)


;*** Windows ***
POSITION_FICTIVE_EX	DQ 16 DUP (0)	;Mutex - prebirane fiktivni odmerovani (1/64000 um)
POSITION_REAL_EX	DQ 16 DUP (0)	;Mutex - prebirane realne odmerovani (1/64000 um)

POSITION_BUSY_WIN	DB 0		;synchronizace Position - Mutex
DISTANCE_BUSY_WIN	DB 0		;synchronizace Distance - Mutex

lpPB20PI		DD 0		;pointer PB20PI (pointry)
lpPB20PI2		DD 0		;pointer PB20PI2
lpBZH08PI		DD 0		;pointer BZH08PI
lpBZH08PI2		DD 0		;pointer BZH08PI2

DISTANCE		DD 0		;aktualni tecnova distance (1/8 um)
DISTANCE_X_EX		DQ 16 DUP (0)	;Mutex - prebirane slozkove distance (1/64000 um)

lpBZH08MAN		DD 0		;pointer BZH08MAN
lpCONT_AUTMAN		DD 0		;pointer CONT_AUTMAN
lpEXT_CONT_AUTMAN	DD 0		;pointer EXT_CONT_AUTMAN
lpB_DRT_FEEDF_EX	DD 0 		;pointer B_DRT (1/64000 um)
lpVRETENO_X		DD 0		;pointer VRETENO_X
lpVRETENO2_X		DD 0		;pointer VRETENO2_X
Knob1Step		DW 0		;aktualni krok 1.tocitka
Knob2Step		DW 0		;aktualni krok 2.tocitka
lpF_SKU_EX		DD 0		;pointer na F_SKU_EX 
lpDIFCIT_X		DD 0		;pointer na diferencni citac X
lpSERV_ACTIVE		DD 0		;pointer na SERV_ACTIVE
lpB_DRTOUT		DD 0		;pointer na B_DRTAXIS.DRTOUTD.AX_X
lpSU_UOUT0		DD 0		;pointer na SU_UOUT
lpSU_IRC0		DD 0		;pointer na SU_IRC0
lpSU_STAT0		DD 0		;pointer na SU_STAT0
lpSU_CHECK_NI_INDIK	DD 0		;pointer na SU_CHECK_NI_INDIK
lpSU_CHECK_NI_ABS	DD 0		;pointer na SU_CHECK_NI_ABS
lpVAZBAPI		DD 0		;pointer na VAZBAPI
lpVAZBAPI2		DD 0		;pointer na VAZBAPI2
lpSERV_LINK_XS		DD 0		;pointer na SERV_LINK_XS


;Odmerovani CAN-BUS pohonu
;Aktualni poloha
CAN_position_1		DD	0	;Pro CAN-BUS - dle ID CAN kanalu
CAN_position_2		DD	0
CAN_position_3		DD	0
CAN_position_4		DD	0
CAN_position_5		DD	0
CAN_position_6		DD	0
CAN_position_7		DD	0
CAN_position_8		DD	0
CAN_position_rezerv	DD 8 DUP (0)

;Referencni poloha pro absolutni snimace R754-759
CAN_position_refer_1	DD	0	;Pro CAN-BUS - dle servosmycek (os R290}
CAN_position_refer_2	DD	0
CAN_position_refer_3	DD	0
CAN_position_refer_4	DD	0
CAN_position_refer_5	DD	0
CAN_position_refer_6	DD	0
CAN_position_refer_7	DD	0
CAN_position_refer_8	DD	0
CAN_position_refer_rez	DD 8 DUP (0)

;Konfigurace pro absolutni odmerovani R752,R753
CAN_ABSOLUTE_ENCODER	DW 16 DUP (0)



;Pro Windows

;umisteni aktualniho bloku
ActualBlock SECRECBLOCKS <(0)>
ActualBlockRezerv	DD 31 DUP (0)

;Indexy pro kruhovy buffer prijmu bloku

IDX_BLOCK_FREE		DD	0			;MUTEX prvni volny (pro plneni)	(offset po bajtech od pocatku oblasti)
IDX_BLOCK_FULL		DD	0			;MUTEX dalsi pro vyber 			(offset po bajtech od pocatku oblasti)

IDX_BLOCK_BUSY_WIN	DB	0			;Synchronizace pro bloky - mutex
BLOCK_START_WIN		DB	0			;Odstartovani bloku v bufferu
NUM_SECRECBLOCKS	DW	0			;pocet bloku
lpBUFF_BLOCK		DD	0			;Pointer na buffer bloku
BLOCK_NEXT_WIN		DB	0			;priznak dalsi blok pro generovani udalosti 

EVENT_STATUS_WIN	DB	0			;priznak pro zmenu statusu pro generovani udalosti 
WINSTATUS_WIN		DD	0			;status
WINSTATBLOCK_WIN	DD	0			;pointer
REQMODIF_WIN		DD	0			;modifikace rezimu (REQM_BlockByBlock, REQM_CondStop,..) 
BLOCK_BB_WIN 		DD	0			;pro AUT-BB (BB_Enable, BB_Active, BB_Start)
BLOCK_FLAGS		DD	0			;ruzne flagy (BLOCKFINISHED)				
			

;****konec*****
data_com_end	DW	0
data_com_len	EQU (data_com_end-data_com_begin)
DATA_COM ENDS
;--------------------------------------------------
